/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.www;

import com.queplix.core.client.app.rpc.DisplayableException;
import com.queplix.core.client.app.rpc.DisplayableStackTraceException;
import com.queplix.core.client.app.rpc.RPCException;
import com.queplix.core.integrator.security.WebLoginManager;
import com.queplix.core.utils.StringHelper;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;

import javax.servlet.http.HttpServletRequest;

/**
 * GWT Helper.
 *
 * @author Sultan Tezadov
 * @since 11 Dec 2006
 */
public final class GWTHelper {

    private static AbstractLogger logger = Log.getLog(GWTHelper.class);

    private GWTHelper() {
    } // disable instantiation

    /**
     * Checks if the user is authenticated.
     */
    public static void checkLogin(HttpServletRequest request)
            throws DisplayableException {
        if(request.getSession().getAttribute(
                WebLoginManager.LOGON_SESSION_ATTR) == null) {
            throw new DisplayableException("User session has expired. ");
        }
    }

    /**
     * Check if this exception can be thrown and re-throw it, or create
     * {@link com.queplix.core.client.app.rpc.DisplayableStackTraceException}
     * with all information of incoming exception.
     *
     * @param e exception prototype
     * @throws RPCException always thrown exception.
     */
    public static void throwSerializableException(Throwable e)
            throws RPCException {
        if(e instanceof RPCException) {
            throw (RPCException) e;
        } else {
            throw new DisplayableStackTraceException(e.getMessage(),
                    StringHelper.getExceptionStacktrace(e));
        }
    }

}
