package com.queplix.tools.fkchecker.client.handlers;

import com.queplix.tools.fkchecker.client.helpers.PropertiesHelper;
import com.queplix.tools.fkchecker.kernel.sources.ForeignKeysSource;
import com.queplix.tools.fkchecker.kernel.sources.ForeignKeysSourceFactory;
import com.queplix.tools.fkchecker.kernel.types.ForeignKey;

import java.io.FileReader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.*;

/**
 * @author dmitry.antonov
 */
public class SourcesComparer {

    private final Set<ForeignKey> constraints1 = new HashSet<ForeignKey>();
    private final Set<ForeignKey> constraints2 = new HashSet<ForeignKey>();
    private final Logger logger = Logger.getLogger("FOREIGN_KEYS_CHECKER");

    private void loadSources(Set<ForeignKey> constraints, String fileName) throws Exception {
        Properties prop = new Properties();
        prop.load(new FileReader(fileName));
        Properties[] splittedProperties = PropertiesHelper.splitProperties(prop);
        for (Properties sourceProperties : splittedProperties) {
            ForeignKeysSource[] sources = ForeignKeysSourceFactory.getInstance().createForeignKeySource(sourceProperties);
            for (ForeignKeysSource source : sources) {
                try {
                    source.openSource();
                    while (source.hasNextForeignKey()) {
                        constraints.add(source.nextForeignKey());
                    }
                }
                finally {
                    source.closeSource();
                }
            }
        }
    }

    public void compareSources() {
        int diffCounter = 0;
        logger.log(Level.OFF, "Differences between constraints sources:\n");
        logger.log(Level.OFF, "--------------------------------------\n");
        for (ForeignKey key : constraints1) {
            if (!constraints2.contains(key)) {
                logger.log(Level.OFF, "Constraint " + key + " was not found\n");
                diffCounter++;
            }
        }
        logger.log(Level.OFF, "======================================\n");
        for (ForeignKey key : constraints2) {
            if (!constraints1.contains(key)) {
                logger.log(Level.OFF, "Constraint " + key + " was not found\n");
                diffCounter++;
            }
        }
        logger.log(Level.OFF, "--------------------------------------\n");
        logger.log(Level.OFF, "*********There are " + diffCounter + " differences*********\n");
        logger.log(Level.OFF, "--------------------------------------\n");
    }

    public SourcesComparer(String fileName1, String fileName2) throws Exception {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(){
            public String format(LogRecord record) {
                return record.getMessage();
            }
        });
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        loadSources(constraints1, fileName1);
        loadSources(constraints2, fileName2);
    }

}
