package com.queplix.tools.fkchecker.kernel.sources;

import java.util.Properties;

/**
 * @author dmitry.antonov
 */
public class ForeignKeysSourceFactory {
    private static ForeignKeysSourceFactory instance = new ForeignKeysSourceFactory();

    public static ForeignKeysSourceFactory getInstance() {
        return instance;
    }

    public ForeignKeysSource[] createForeignKeySource(Properties properties) {
        String sourceType = properties.getProperty("sourceType");
        if (sourceType.equals("xml")) {
            return XmlSource.createSources(properties);
        }
        else if (sourceType.equals("mssql")) {
            return MsSqlSource.createSources(properties);
        }
        else {
            throw new IllegalArgumentException("Source type \'" + sourceType + "\' is illegal!");
        }
    }
}
