package com.queplix.tools.fkchecker.kernel.types;

/**
 * @author dmitry.antonov
 */
public class ForeignKey {

    private final KeyPair startPoint;
    private final KeyPair endPoint;
    private final String name;

    public ForeignKey(String name, KeyPair startPoint, KeyPair endPoint) {
        this.name = name;
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    public int hashCode() {
        return startPoint.hashCode() + endPoint.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ForeignKey) {
            ForeignKey fk = (ForeignKey) obj;
            return (startPoint.equals(fk.startPoint) && endPoint.equals(fk.endPoint)) ||
                   (startPoint.equals(fk.endPoint) && endPoint.equals(fk.startPoint));
        }
        else {
            return false;
        }
    }

    public String toString() {
        return "Link '" + name + "' {" + startPoint + "<->" + endPoint + "}";    
    }
}

