package com.queplix.installer;

import com.izforge.izpack.event.SimpleUninstallerListener;
import com.izforge.izpack.util.AbstractUIProgressHandler;

import java.io.*;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ArrayList;

/**
 * @author dmitry.antonov
 */
public class QuewebUninstallerListener extends SimpleUninstallerListener {

    public static String[] exec(String command) {
        List result = new ArrayList();
        try {
            Process proc = Runtime.getRuntime().exec(command);
            InputStream stderr = proc.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            String line;
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
            proc.waitFor();
        } catch (Throwable t) {
            t.printStackTrace();
        }
        return (String[]) result.toArray(new String[result.size()]);
    }
    
    private static final String UNINSTALLER_PROPERTIES = "uninstallerProperties.xml";


    private void uninstallServices(File propertiesFile, AbstractUIProgressHandler handler) throws IOException {
        int step = 1;
        handler.progress(step++, "Removing installed Windows services...");
        Properties properties = new Properties();
        properties.loadFromXML(new FileInputStream(propertiesFile));
        if (properties.getProperty("installScheduler").equals("service")) {
            handler.progress(step++, "Stopping and removing QueWeb Scheduler Service");
            exec("\"" + properties.getProperty("INSTALL_PATH") + "\\Scheduler\\stop_scheduler_service.bat");
            try {
                Thread.sleep(2000);
            } 
            catch(InterruptedException e) {
                System.out.println(e);
            }
        }
        if (properties.getProperty("installMySQL").equals("yes")) {
            handler.progress(step++, "Stopping MySQL service...");
            exec("net stop MySQL");
            handler.progress(step++, "Removing MySQL service...");
            exec("\"" + properties.getProperty("MYSQL_PATH") + "\\bin\\mysqld.exe\" --remove");
        }
        if (properties.getProperty("INSTALL_SERVICE").equals("yes")) {
            handler.progress(step++, "Stopping QueWeb service...");
            exec("net stop QueWeb");
            handler.progress(step++, "Removing QueWeb service...");
            exec("cmd /C \"" + properties.getProperty("JBOSS_PATH") + "\\bin\\UninstallQueWeb-NT.bat\"");
            handler.progress(step++, "Done");
        }
    }


    /*
    * (non-Javadoc)
    *
    * @see com.izforge.izpack.uninstaller.UninstallerListener#beforeDeletion(java.util.List,
    * com.izforge.izpack.util.AbstractUIProgressHandler)
    */
    public void beforeDeletion(List files, AbstractUIProgressHandler handler) throws Exception {
        for (Iterator iterator = files.iterator(); iterator.hasNext();) {
            File file = (File) iterator.next();
            if (file.getName().equals(UNINSTALLER_PROPERTIES)) {
                uninstallServices(file, handler);
                return;
            }
        }
    }

}
