<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  ~
  -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <project name="assemble-qmodules" default="assemble-qmodules"
                 basedir=".">
            <target name="assemble-qmodules">
                <xsl:apply-templates/>
            </target>
        </project>
    </xsl:template>

    <xsl:template match="module-location">
        <!--define dir-->
        <var name="processing-qmodule.dir" unset="true"/>
        <xsl:text disable-output-escaping="yes">
        &lt;property name="processing-qmodule.dir" value='${application.dir}/</xsl:text>
        <xsl:value-of select="@dir"/>
        <xsl:text disable-output-escaping="yes">'/&gt;
        </xsl:text>
        <!--define module name-->
        <var name="processing-qmodule.name" unset="true"/>
        <xsl:text disable-output-escaping="yes">
        &lt;property name="processing-qmodule.name" value='</xsl:text>
        <xsl:value-of select="@name"/>
        <xsl:text disable-output-escaping="yes">'/&gt;
        </xsl:text>
        
        <!--run single module assembling process-->
        <ant antfile="assemble-qmodule.xml" target="assemble-qmodule"/>
    </xsl:template>
</xsl:stylesheet>