<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  ~
  -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <project name="dist-qmodule" default="dist-qmodule" basedir=".">
        <target name="dist-qmodule">
                <xsl:apply-templates/>
            </target>
        </project>
    </xsl:template>

    <xsl:template match="module-location">
        <xsl:text disable-output-escaping="yes">&lt;var name="qmodule.dir" value="${application.dir}/</xsl:text>
        <xsl:value-of select='@dir'/>
        <xsl:text disable-output-escaping="yes">"/&gt;</xsl:text>

        <xsl:text disable-output-escaping="yes">&lt;var name="qmodule.name" value="</xsl:text>
        <xsl:value-of select='@name'/>
        <xsl:text disable-output-escaping="yes">"/&gt;</xsl:text>

        <xsl:text disable-output-escaping="yes">
        <![CDATA[
        <var name="qmodule.ejb.id" value="${qmodule.name}-ejb"/>
        <var name="qmodule.ejb-dist.dir" value="${qmodule.dir}/${qmodule.ejb.id}/dist"/>
        <var name="qmodule.dist.jar" value="${qmodule.ejb-dist.dir}/${qmodule.ejb.id}.jar"/>
        <var name="qmodule.ejb-build.dir" value="${qmodule.dir}/${qmodule.ejb.id}/build/ear-module"/>
        <!--<var name="qmodule.ejb-jar-file" value="${qmodule.ejb-build.dir}/META-INF/ejb-jar.xml"/>-->

        <var name="qmodule.ejb-temp.dir" value="${qmodule.dir}/${qmodule.ejb.id}/build/tmp"/>
        
        <copy todir="${qmodule.ejb-temp.dir}" overwrite="false" failonerror="false">
            <fileset dir="${qmodule.ejb-build.dir}"/>
        </copy>

        <jar jarfile="${qmodule.dist.jar}" compress="false" manifest="${qmodule.ejb-build.dir}/META-INF/MANIFEST.MF">
            <fileset dir="${qmodule.ejb-temp.dir}"/>
        </jar>
        ]]>
        </xsl:text>
    </xsl:template>
</xsl:stylesheet>