<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  ~
  -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <project name="generate-ejb-refs" default="generate-ejb-refs"
                 basedir=".">
            <target name="generate-ejb-refs">
                <xsl:apply-templates/>
            </target>
        </project>
    </xsl:template>

    <xsl:template match="ejb">
        <!--define processing-qmodule name-->
        <var name="processing-qmodule.name" unset="true"/>
        <xsl:text disable-output-escaping="yes">
        &lt;property name="processing-qmodule.name" value='</xsl:text>
        <xsl:value-of select="@qmodule"/>
        <xsl:text disable-output-escaping="yes">'/&gt;
        </xsl:text>
        <!--define processing ejb name-->
        <var name="processing-ejb.name" unset="true"/>
        <xsl:text disable-output-escaping="yes">
        &lt;property name="processing-ejb.name" value='</xsl:text>
        <xsl:value-of select="@ejb-name"/>
        <xsl:text disable-output-escaping="yes">'/&gt;
        </xsl:text>

        <!--write property file, so it could be loaded later-->
        <xsl:text disable-output-escaping="yes">
        <![CDATA[
        <echo file="${processing-qmodule.name}-${processing-ejb.name}-refs-to-inject.xmlpart">
        ]]>
        &lt;![CDATA[
        </xsl:text>

        <xsl:apply-templates select="node()|text()"/>

        <xsl:text disable-output-escaping="yes">
        ]]&gt;
        <![CDATA[
        </echo>
        ]]>
        </xsl:text>
    </xsl:template>

    <xsl:template match="ejb-ref|ejb-ref-type|ejb-ref-name|home|remote|ejb-link|ejb-local-ref|local-home|local|resource-ref|res-ref-name|res-type|res-auth">
        <xsl:copy>
            <xsl:apply-templates select="node()|text()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>