<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  ~
  -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <project name="inject-dependencies" default="inject-dependencies"
                 basedir=".">
            <target name="inject-dependencies">
                <xsl:apply-templates/>
            </target>
        </project>
    </xsl:template>

    <xsl:template match="ejb">
        <!--define processing-qmodule name-->
        <var name="processing-qmodule.name" unset="true"/>
        <xsl:text disable-output-escaping="yes">
        &lt;property name="processing-qmodule.name" value='</xsl:text>
        <xsl:value-of select="@qmodule"/>
        <xsl:text disable-output-escaping="yes">'/&gt;
        </xsl:text>

        <!--define processing directory name-->
        <xsl:text disable-output-escaping="yes">
        &lt;propertycopy property="processing-qmodule.dir" from="${processing-qmodule.name}.dir" /&gt;
        &lt;var name="processing-qmodule.dir" value="${application.dir}/${processing-qmodule.dir}" /&gt;
        </xsl:text>

        <!--define processing ejb name-->
        <var name="processing-ejb.name" unset="true"/>
        <xsl:text disable-output-escaping="yes">
        &lt;property name="processing-ejb.name" value='</xsl:text>
        <xsl:value-of select="@ejb-name"/>
        <xsl:text disable-output-escaping="yes">'/&gt;
        </xsl:text>

        <!--define injecting element value-->
        <var name="injecting-value" unset="true"/>
        <xsl:text disable-output-escaping="yes">
        &lt;loadfile property="injecting-value" srcFile="<![CDATA[${processing-qmodule.name}-${processing-ejb.name}-refs-to-inject.xmlpart]]>"/&gt;
        </xsl:text>

        <!--run single module injection process-->
        <ant antfile="inject-dependency.xml" target="inject-dependency"/>
    </xsl:template>
</xsl:stylesheet>