<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  ~
  -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:param name="ejb-name"/>
    <xsl:param name="ejb-include-elements"/>
    <!-- XSLT Template to copy anything, priority="-1" -->
    <xsl:template match="@*|node()|text()|comment()|processing-instruction()"
                  priority="-1">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()|text()|comment()|processing-instruction()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="session|message-driven|entity">
        <xsl:variable name="current-ejb-name"><xsl:value-of select="@id"/></xsl:variable>
        <xsl:choose>
            <xsl:when test="$ejb-name = $current-ejb-name">
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>
                <xsl:value-of select="local-name()"/>
                <xsl:text disable-output-escaping="yes"> id="</xsl:text>
                <xsl:value-of select="@id"/>
                <xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
                <xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()"/>
                <xsl:value-of select="$ejb-include-elements" disable-output-escaping="yes"/>
                <xsl:text disable-output-escaping="yes">&lt;/session&gt;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>