CREATE TABLE dbo.QW_ENVIRONMENT (
     [qw_envid] [int] NOT NULL,
     [qw_envlabel] [varchar] (100) NULL,
     [qw_testedby] [varchar] (100) NULL,
     [qw_os] [varchar] (50) NULL,
     [qw_osversion] [varchar] (50) NULL,
     [qw_hardwareplatform] [varchar] (100) NULL,
     [qw_networkenv] [varchar] (100) NULL,
     [qw_uienv] [varchar] (100) NULL,
     [qw_otherenv] [varchar] (100) NULL,
     [qw_description] [varchar] (2000) COLLATE Latin1_General_CI_AS NOT NULL,
     [qw_dateentered] [datetime] NULL
     CONSTRAINT [pk_qw_environment] PRIMARY KEY CLUSTERED ([qw_envid]) WITH FILLFACTOR = 80 ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE dbo.QW_EVENTTYPE (
    [qw_eventid] [int] NOT NULL,
    [qw_eventtype] [varchar] (100)
    CONSTRAINT [pk_qw_eventid] PRIMARY KEY CLUSTERED ([qw_eventid]) WITH FILLFACTOR = 80 ON [PRIMARY]
)  ON [PRIMARY]
GO

drop table dbo.QW_TICKETEVENT
GO

CREATE TABLE dbo.QW_TICKETEVENT (
    [qw_eventid] [int] NOT NULL ,
    [qw_ticketid] [int] NOT NULL ,
    [qw_eventtype] [int] NOT NULL,
    [qw_eventdate] [datetime] NULL,
    [qw_madeby] [int] NOT NULL,
    [qw_customer] [int] NULL,
    [qw_oldvalue] [varchar] (100) NULL,
    [qw_newvalue] [varchar] (100) NULL
    CONSTRAINT [pk_qw_ticketevent] PRIMARY KEY CLUSTERED ([qw_eventid]) WITH FILLFACTOR = 80 ON [PRIMARY],
    CONSTRAINT [fk_qw_ticketevent_ticket] FOREIGN KEY ([qw_ticketid]) REFERENCES QW_TICKET ([qw_ticketid]),
    CONSTRAINT [fk_qw_eventtype] FOREIGN KEY ([qw_eventtype]) REFERENCES QW_EVENTTYPE ([qw_eventid]),
) ON [PRIMARY]
GO

-- all new update scripts must include a line like this:
UPDATE QX_SYS_PROP SET PROP_VAL = '017' WHERE (PROP_ID = 'DB_APP_VERSION');