DROP TABLE QW_ENVIRONMENT
GO

CREATE TABLE dbo.QW_ENVIRONMENT (
     [qw_envid] [int] NOT NULL,
     [qw_envconfname] [varchar] (100) NULL,
     [qw_productid] [int] NOT NULL,
     [qw_orgid] [int] NOT NULL,
     [qw_appos] [int] NOT NULL,
     [qw_apposversion] [int] NULL,
     [qw_apphardware] [int] NOT NULL,
     [qw_dbos] [int] NOT NULL,
     [qw_dbosversion] [int] NULL,
     [qw_dbhardware] [int] NOT NULL,
     [qw_description] [varchar] (2000) COLLATE Latin1_General_CI_AS NOT NULL,
     CONSTRAINT [pk_qw_environment] PRIMARY KEY CLUSTERED ([qw_envid]) WITH FILLFACTOR = 80 ON [PRIMARY],
     CONSTRAINT [fk_qw_productid_env] FOREIGN KEY ([qw_productid]) REFERENCES QW_PRODUCT ([qw_productid]),
     CONSTRAINT [fk_qw_orgid_env] FOREIGN KEY ([qw_orgid]) REFERENCES QW_ORGANIZATION ([qw_orgid])
) ON [PRIMARY]
GO

/*environment os*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_environment','qw_os',14,0,'Windows 98');
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_environment','qw_os',14,1,'Windows 2000');
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_environment','qw_os',14,2,'Windows XP');

/*environment hardware*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_environment','qw_hardware',14,0,'test hard 1');
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_environment','qw_hardware',14,1,'test hard 2');
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_environment','qw_hardware',14,2,'test hard 3');
GO

CREATE VIEW dbo.QW_DD_ENVIRONMENTOS_VW AS
SELECT qw_enumvalue AS pkey, qw_enumlabel AS value
FROM QW_FIELDINFO
WHERE (qw_tablename = 'qw_environment')
  AND (qw_columnname = 'qw_os')
GO

CREATE VIEW dbo.QW_DD_ENVIRONMENTHARDWARE_VW AS
SELECT qw_enumvalue AS pkey, qw_enumlabel AS value
FROM QW_FIELDINFO
WHERE (qw_tablename = 'qw_environment')
  AND (qw_columnname = 'qw_hardware')
GO

-- all new update scripts must include a line like this:
UPDATE QX_SYS_PROP SET PROP_VAL = '023' WHERE (PROP_ID = 'DB_APP_VERSION');