CREATE TABLE dbo.QW_WORKFLOW (
    qw_workflowid  int  NOT NULL,
    qw_objecttype  int  NOT NULL,
    qw_statusfrom  int  NULL,
    qw_statusto    int  NULL,
    qw_roleid      int  NULL,
    CONSTRAINT pk_qw_workflow PRIMARY KEY (qw_workflowid)
)
GO

INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_workflow','qw_objecttype',14,0,'Solution');
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_workflow','qw_objecttype',14,1,'Ticket');
GO

CREATE VIEW dbo.QW_DD_WORKFLOWOBJECTS_VW AS
SELECT
  qw_enumvalue AS pkey, qw_enumlabel AS value
FROM
  QW_FIELDINFO
WHERE (qw_tablename = 'qw_workflow')
  AND (qw_columnname = 'qw_objecttype')
GO

CREATE VIEW QW_DD_WORKFLOWSTATUS_VW AS
SELECT 
  qw_enumvalue AS pkey, qw_enumlabel AS value, 0 AS object
FROM 
  QW_FIELDINFO
WHERE (qw_tablename = 'qw_solution')
  AND (qw_columnname = 'qw_solutionstatus')
UNION ALL
SELECT 
  qw_enumvalue AS pkey, qw_enumlabel AS value, 1
FROM 
  QW_FIELDINFO
WHERE (qw_tablename = 'qw_ticket')
  AND (qw_columnname = 'qw_status')
GO

-- all new update scripts must include a line like this:
UPDATE QX_SYS_PROP SET PROP_VAL = '036' WHERE (PROP_ID = 'DB_APP_VERSION');
