DELIMITER //

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default ticket status.' where PROP_ID = 'IN_EMAIL_TICKET_STATUS'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default ticket priority.' where PROP_ID = 'IN_EMAIL_TICKET_PRIORITY'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default ticket type.' where PROP_ID = 'IN_EMAIL_TICKET_TYPE'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default ticket source.' where PROP_ID = 'IN_EMAIL_TICKET_SOURCE'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default ticket impact.' where PROP_ID = 'IN_EMAIL_TICKET_IMPACT'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default ticket owner.' where PROP_ID = 'IN_EMAIL_TICKET_OWNER'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default source field for incoming Interaction.' where PROP_ID = 'IN_EMAIL_INTER_SOURCE'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default agent for incoming Interaction.' where PROP_ID = 'IN_EMAIL_INTER_DEFAULT_AGENT'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default Ticket Reported Build Version.' where PROP_ID = 'IN_EMAIL_TICKET_RVERSION'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing - default Ticket Agent.' where PROP_ID = 'IN_EMAIL_TICKET_AGENT'
//

update QX_SYS_PROP set DESCRIPTION = 'Email processing  - default Ticket Product.' where PROP_ID = 'IN_EMAIL_TICKET_PRODUCT'
//

update QX_SYS_PROP set DESCRIPTION = 'Default Customer name  used in Email processing.' where PROP_ID = 'IN_EMAIL_DEFAULT_CUSTOMER_NAME'
//

update QX_SYS_PROP set DESCRIPTION = 'Default Customer ID  used in Email processing.' where PROP_ID = 'IN_EMAIL_DEFAULT_CUSTOMER_ID'
//

update QX_SYS_PROP set DESCRIPTION = 'Default value of the Interaction Origin field for outgoing emails.', PROP_VAL = '4' where PROP_ID = 'OUT_EMAIL_INTER_SOURCE'
//

-- QW_TICKETESCALATION_PRIORITY --

CREATE TABLE TMP_TICKETESCALATION_PRIORITY(
	QW_PRIORITY int NULL,
	QW_ESCALATIONID int NULL
)
//

INSERT INTO TMP_TICKETESCALATION_PRIORITY select * from QW_TICKETESCALATION_PRIORITY
//

TRUNCATE TABLE QW_TICKETESCALATION_PRIORITY
//

ALTER TABLE QW_TICKETESCALATION_PRIORITY ADD QW_ID int NULL
//

ALTER TABLE QW_TICKETESCALATION_PRIORITY MODIFY QW_ID int NOT NULL
//

CREATE PROCEDURE TMP()
BEGIN
  DECLARE id int;
  DECLARE prt int;
  DECLARE esc int;
  DECLARE done int DEFAULT 0;
  DECLARE cur CURSOR FOR SELECT QW_PRIORITY, QW_ESCALATIONID FROM TMP_TICKETESCALATION_PRIORITY;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  OPEN cur;
  FETCH cur INTO prt, esc;
  WHILE done = 0 DO
    CALL QX_NEXT_KEY('qw_ticketescalation_priority', 1, @id);
    INSERT INTO QW_TICKETESCALATION_PRIORITY (QW_ID, QW_PRIORITY, QW_ESCALATIONID) VALUES (@id, prt, esc);
    FETCH cur INTO prt, esc;
  END WHILE;
  CLOSE cur;
END
//

CALL TMP()
//

DROP PROCEDURE TMP
//

DROP TABLE TMP_TICKETESCALATION_PRIORITY
//


-- QW_TICKETESCALATION_RECIPIENT --

CREATE TABLE TMP_TICKETESCALATION_RECIPIENT(
	QW_RECIPIENT int NULL,
	QW_ESCALATIONID int NULL
)
//

INSERT INTO TMP_TICKETESCALATION_RECIPIENT select * from QW_TICKETESCALATION_RECIPIENT
//

TRUNCATE TABLE QW_TICKETESCALATION_RECIPIENT
//

ALTER TABLE QW_TICKETESCALATION_RECIPIENT ADD QW_ID int NULL
//

ALTER TABLE QW_TICKETESCALATION_RECIPIENT MODIFY QW_ID int NOT NULL
//
CREATE PROCEDURE TMP()
BEGIN
  DECLARE done int DEFAULT 0;
  DECLARE rcpt int;
  DECLARE esc int;
  DECLARE id int;
  DECLARE cur CURSOR FOR  SELECT QW_RECIPIENT, QW_ESCALATIONID FROM TMP_TICKETESCALATION_RECIPIENT;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  OPEN cur;
  FETCH cur INTO rcpt, esc;
  WHILE done = 0 DO
    CALL QX_NEXT_KEY('qw_ticketescalation_recipient', 1, @id);
    INSERT INTO QW_TICKETESCALATION_RECIPIENT (QW_ID, QW_RECIPIENT, QW_ESCALATIONID) VALUES(@id, rcpt, esc);
    FETCH cur INTO rcpt, esc;
  END WHILE;
  CLOSE cur;
END
//

CALL TMP()
//

DROP PROCEDURE TMP
//

DROP TABLE TMP_TICKETESCALATION_RECIPIENT
//

-- QW_TICKETESCALATION_STATUS --

CREATE TABLE TMP_TICKETESCALATION_STATUS(
	QW_STATUS int NULL,
	QW_ESCALATIONID int NULL
)
//

INSERT INTO TMP_TICKETESCALATION_STATUS select * from QW_TICKETESCALATION_STATUS
//

TRUNCATE TABLE QW_TICKETESCALATION_STATUS
//

ALTER TABLE QW_TICKETESCALATION_STATUS ADD QW_ID int NULL
//

ALTER TABLE QW_TICKETESCALATION_STATUS MODIFY QW_ID int NOT NULL
//
CREATE PROCEDURE TMP()
BEGIN
  DECLARE done int DEFAULT 0;
  DECLARE stat int;
  DECLARE esc int;
  DECLARE id int;
  DECLARE cur CURSOR FOR SELECT QW_STATUS, QW_ESCALATIONID FROM TMP_TICKETESCALATION_STATUS;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  OPEN cur;
  FETCH cur INTO stat, esc;
  WHILE done = 0 DO
    CALL QX_NEXT_KEY('qw_ticketescalation_status', 1, @id);
    INSERT INTO QW_TICKETESCALATION_STATUS (QW_ID, QW_STATUS, QW_ESCALATIONID) VALUES(@id, stat, esc);
    FETCH cur INTO stat, esc;
  END WHILE;
  CLOSE cur;
END
//

CALL TMP()
//

DROP PROCEDURE TMP
//

DROP TABLE TMP_TICKETESCALATION_STATUS
//


-- QW_TICKETNOTIFICATION_PRIORITY --

CREATE TABLE TMP_TICKETNOTIFICATION_PRIORITY(
	QW_PRIORITY int NULL,
	QW_NOTIFICATIONID int NULL
)
//

INSERT INTO TMP_TICKETNOTIFICATION_PRIORITY select * from QW_TICKETNOTIFICATION_PRIORITY
//

TRUNCATE TABLE QW_TICKETNOTIFICATION_PRIORITY
//

ALTER TABLE QW_TICKETNOTIFICATION_PRIORITY ADD QW_ID int NULL
//

ALTER TABLE QW_TICKETNOTIFICATION_PRIORITY MODIFY QW_ID int NOT NULL
//
CREATE PROCEDURE TMP()
BEGIN
  DECLARE done INT DEFAULT 0;
  DECLARE prt int;
  DECLARE notif int;
  DECLARE id int;
  DECLARE cur CURSOR FOR SELECT QW_PRIORITY, QW_NOTIFICATIONID FROM TMP_TICKETNOTIFICATION_PRIORITY;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  OPEN cur;
  FETCH cur INTO prt, notif;
  WHILE done = 0 DO
    CALL QX_NEXT_KEY('qw_ticketnotification_priority', 1, @id);
    INSERT INTO QW_TICKETNOTIFICATION_PRIORITY (QW_ID, QW_PRIORITY, QW_NOTIFICATIONID) VALUES(@id, prt, notif);
    FETCH cur INTO prt, notif;
  END WHILE;
  CLOSE cur;
END
//

CALL TMP()
//

DROP PROCEDURE TMP
//

DROP TABLE TMP_TICKETNOTIFICATION_PRIORITY
//


-- QW_TICKETNOTIFICATION_RECIP --

CREATE TABLE TMP_TICKETNOTIFICATION_RECIPIENT(
	QW_RECIPIENT int NULL,
	QW_NOTIFICATIONID int NULL
)
//

INSERT INTO TMP_TICKETNOTIFICATION_RECIPIENT select * from QW_TICKETNOTIFICATION_RECIP
//

TRUNCATE TABLE QW_TICKETNOTIFICATION_RECIP
//

ALTER TABLE QW_TICKETNOTIFICATION_RECIP ADD QW_ID int NULL
//

ALTER TABLE QW_TICKETNOTIFICATION_RECIP MODIFY QW_ID int NOT NULL
//
CREATE PROCEDURE TMP()
BEGIN
  DECLARE done int DEFAULT 0;
  DECLARE rpt int;
  DECLARE notif int;
  DECLARE id int;
  DECLARE cur CURSOR FOR SELECT QW_RECIPIENT, QW_NOTIFICATIONID FROM TMP_TICKETNOTIFICATION_RECIPIENT;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  OPEN cur;
  FETCH cur INTO rpt, notif;
  WHILE done = 0 DO
    CALL QX_NEXT_KEY('qw_ticketnotification_recip', 1, @id);
    INSERT INTO QW_TICKETNOTIFICATION_RECIP (QW_ID, QW_RECIPIENT, QW_NOTIFICATIONID) VALUES(@id, rpt, notif);
    FETCH cur INTO rpt, notif;
  END WHILE;
  CLOSE cur;
END
//

CALL TMP()
//

DROP PROCEDURE TMP
//

DROP TABLE TMP_TICKETNOTIFICATION_RECIPIENT
//

-- QW_TICKETNOTIFICATION_STATUS --

CREATE TABLE TMP_TICKETNOTIFICATION_STATUS(
	QW_STATUS int NULL,
	QW_NOTIFICATIONID int NULL
)
//

INSERT INTO TMP_TICKETNOTIFICATION_STATUS select * from QW_TICKETNOTIFICATION_STATUS
//

TRUNCATE TABLE QW_TICKETNOTIFICATION_STATUS
//

ALTER TABLE QW_TICKETNOTIFICATION_STATUS ADD QW_ID int NULL
//

ALTER TABLE QW_TICKETNOTIFICATION_STATUS MODIFY QW_ID int NOT NULL
//
CREATE PROCEDURE TMP()
BEGIN
  DECLARE done int DEFAULT 0;
  DECLARE stat int;
  DECLARE notif int;
  DECLARE id int;
  DECLARE cur CURSOR FOR SELECT QW_STATUS, QW_NOTIFICATIONID FROM TMP_TICKETNOTIFICATION_STATUS;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  OPEN cur;
  FETCH cur INTO stat, notif;
  WHILE done=0 DO
    CALL QX_NEXT_KEY('qw_ticketnotification_status', 1, @id);
    INSERT INTO QW_TICKETNOTIFICATION_STATUS (QW_ID, QW_STATUS, QW_NOTIFICATIONID) VALUES(@id, stat, notif);
    FETCH cur INTO stat, notif;
  END WHILE;
  CLOSE cur;
END
//

CALL TMP()
//

DROP PROCEDURE TMP
//

DROP TABLE TMP_TICKETNOTIFICATION_STATUS
//


-- QW_INTER_TICKET --

CREATE TABLE TMP_INTER_TICKET(
	QW_INTERACTIONID int NULL,
	QW_TICKETID int NULL
)
//

ALTER TABLE QW_INTER_TICKET DROP PRIMARY KEY
//

INSERT INTO TMP_INTER_TICKET select * from QW_INTER_TICKET
//

TRUNCATE TABLE QW_INTER_TICKET
//

ALTER TABLE QW_INTER_TICKET ADD QW_ID int NULL
//

ALTER TABLE QW_INTER_TICKET MODIFY QW_ID int NOT NULL
//

ALTER TABLE QW_INTER_TICKET ADD CONSTRAINT PK_INTER_TICKET PRIMARY KEY (QW_ID)
//
CREATE PROCEDURE TMP()
BEGIN
  DECLARE done int DEFAULT 0;
  DECLARE ticket int;
  DECLARE inter int;
  DECLARE id int;
  DECLARE cur CURSOR FOR SELECT QW_INTERACTIONID, QW_TICKETID FROM TMP_INTER_TICKET;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  OPEN cur;
  FETCH cur INTO inter, ticket;
  WHILE done = 0 DO
    CALL QX_NEXT_KEY('qw_inter_ticket', 1, @id);
    INSERT INTO QW_INTER_TICKET (QW_ID, QW_INTERACTIONID, QW_TICKETID) VALUES(@id, inter, ticket);
    FETCH NEXT FROM cur INTO inter, ticket;
  END WHILE;
  CLOSE cur;
END
//

CALL TMP()
//

DROP PROCEDURE TMP
//

DROP TABLE TMP_INTER_TICKET
//

-- all new update scripts must include a line like this:
UPDATE QX_SYS_PROP SET PROP_VAL = '057' WHERE (PROP_ID = 'DB_APP_VERSION');
//