/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * JEObjectHandler implementation for AttachmentObjects.
 *
 * @author Sergei Savchuk
 */

public class AttachmentObjectsObjectHandler extends JEObjectHandler {

    public static final String ENTITY = "attachment_objects";

    public String getEntityName() {
        return ENTITY;
    }

    public Class getObjectClass() {
        return AttachmentObjectsObject.class;
    }

    public static JEObjectHandler selectByIDs(JEOManagerLocal manager,
                                              LogonSession ls,
                                              long atachmentId, long solutionId,
                                              int type) throws EQLException {
        String eql =
                "select attachment_objects.* where attachment_objects.attachment_id = "
                        + atachmentId +
                        " and attachment_objects.object_id = " + solutionId +
                        " and attachment_objects.object_type = " + type;
        List hndList = manager.select(ls, AttachmentObjectsObjectHandler.class,
                eql);
        return (hndList != null) ? (JEObjectHandler) hndList.get(0):null;
    }

    public static List selectByAttachmentID(JEOManagerLocal manager,
                                            LogonSession ls, long atachmentId)
            throws EQLException {
        String eql =
                "select attachment_objects.* where attachment_objects.attachment_id = "
                        + atachmentId;
        return manager.select(ls, AttachmentObjectsObjectHandler.class, eql);
    }
}
