/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObject;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * Customer JEO handler.
 *
 * @author [LIV] Ladnev Ilya
 * @version $Revision: 1.2 $ $Date: 2006/06/04 00:15:09 $
 */
public class CustomerObjectHandler
        extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */

    public String getEntityName() {
        return "customer";
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return CustomerObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets Customer by ID (unique key).
     *
     * @param manager JEOManager EJB local interface
     * @param ls      LogonSession object with security data
     * @return EmployeeObject, or <code>null</code> if none found
     * @throws EQLException
     */
    public static CustomerObject selectByID(JEOManagerLocal manager,
                                            LogonSession ls, long id)
            throws EQLException {

        String eql = "select customer.* where customer.qw_customerid = " + id;
        List hndList = manager.select(ls, CustomerObjectHandler.class, eql);
        if(hndList == null) {
            return null;
        }
        JEObject jeo = ((JEObjectHandler) hndList.get(0)).getJEObject();
        return (CustomerObject) jeo;
    }

    public static String selectMailByID(EQLManagerLocal eqlManager,
                                        LogonSession ls, long id)
            throws EQLException {
        String eql = "select customer.qw_email where customer.qw_customerid = " + id;
        EQLRes eqlRes = eqlManager.select(ls, eql);
        if(eqlManager.selectCount(ls, eqlRes) > 0) {
            return eqlRes.getRecord(0).getResCell(0).getString();
        } else {
            return null;
        }
    }

    public static Long selectIDByEmail(EQLManagerLocal eqlManager,
                                       LogonSession ls, String emailAddress)
            throws EQLException {
        String eql = "select customer.qw_customerid where customer.qw_email = '" + emailAddress + "'";
        EQLRes eqlRes = eqlManager.select(ls, eql);
        if(eqlManager.selectCount(ls, eqlRes) > 0) {
            return eqlRes.getRecord(0).getResCell(0).getLong();
        } else {
            return null;
        }
    } // selectIDByEmail(EQLManagerLocal, LogonSession, String) : String

    public static Long selectOrgByID(EQLManagerLocal eqlManager,
                                     LogonSession ls, long id)
            throws EQLException {
        String eql = "select customer.qw_orgid where customer.qw_customerid = " + id;
        EQLRes eqlRes = eqlManager.select(ls, eql);
        if(eqlManager.selectCount(ls, eqlRes) > 0) {
            return eqlRes.getRecord(0).getResCell(0).getLong();
        } else {
            return null;
        }
    }

}
