/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * Description.
 *
 * @author rustem.nizamiev
 */
public class InteractionTicketObjectHandler extends JEObjectHandler {

    public static final String ENTITY = "inter_ticket";

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler.getEntityName()
     */

    public String getEntityName() {
        return ENTITY;
    }

    /* (non-Javadoc)
     * @see JEObjectHandler.getObjectClass()
     */
    public Class getObjectClass() {
        return InteractionTicketObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the ticket by its ID (primary key).
     *
     * @param manager JEOManager EJB local interface
     * @param ls      LogonSession object with security data
     * @param id      ticket ID to search by
     * @return ticket JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectByIDs(JEOManagerLocal manager,
                                              LogonSession ls, long ticketId,
                                              long interId)
            throws EQLException {
        String eql = "select inter_ticket.* where inter_ticket.qw_ticketid = "
                + ticketId +
                " and inter_ticket.qw_interactionid = " + interId;
        List hndList = manager.select(ls, InteractionTicketObjectHandler.class,
                eql);
        return (hndList != null) ? (JEObjectHandler) hndList.get(0):null;
    }

}
