/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * Notification Priority Fields JEO handler.
 *
 * @version $Revision$ $Date$
 */
public class NotifPriorityFieldObjectHandler extends JEObjectHandler {

    // ======================================================= Inherited methods

    /*
     * (non-Javadoc)
     * 
     * @see JEObjectHandler#getEntityName()
     */

    public String getEntityName() {
        return "ticketnotification_priority";
    }

    /*
     * (non-Javadoc)
     * 
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return NotifPriorityFieldObject.class;
    }

    /**
     * Select by ID
     *
     * @param local JEOManager local interface
     * @param ls    user logon session
     * @param id    Notification Id
     * @return object or NULL
     * @throws EQLException
     */
    public static List<NotifPriorityFieldObjectHandler> selectByNotificationId(
            JEOManagerLocal local,
            LogonSession ls, Long id)
            throws EQLException {
        if(id == null) {
            return null;
        }
        return local.select(ls, NotifPriorityFieldObjectHandler.class,
                "SELECT ticketnotification_priority.* WHERE ticketnotification_priority.qw_notificationid = "
                        + id);
    }
}
