/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.update;
/*
import java.util.regex.Pattern;

*/

import com.queplix.core.integrator.security.CryptoHelper;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.EQLResCell;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.StringHelper;


/**
 * Change password update business logic.
 *
 * @author [LIV] Ladnev Ilya
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:51 $
 */
public class PasswordUpdate
        extends EntityUpdate {

    /* (non-Javadoc)
     * @see EntityUpdate#beforeUpdate()
     */
    public int beforeUpdate() throws EQLException {

        long time = System.currentTimeMillis();
        INFO("Before update script started...");

        // Initialization.
        LogonSession ls = getLogonSession();
        JEOManagerLocal jeoManager = (JEOManagerLocal) getCOM().
                getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);

        EQLResCell passwordCell = getCell("password");
        EQLResCell password1Cell = getCell("password1");
        String password = passwordCell.getString();
        String password1 = password1Cell.getString();

        if(!StringHelper.isEmpty(password)) {
            if(!password.equals(password1)) {
                throw new EQLException("Entered passwords do not match.");
            }
            password = CryptoHelper.getDigest(password);
        } else {
            if(!StringHelper.isEmpty(password1)) {
                throw new EQLException("Entered passwords do not match.");
            }
        }

        passwordCell.setString(password);

        // Ok.
        INFO("Completed, time (ms) = " + (System.currentTimeMillis() - time));
        return CONTINUE;
    }
}
