/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.utils;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.User;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.ejb.EQLManagerLocalHome;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.jeo.gen.UserObject;
import com.queplix.core.modules.jeo.gen.UserObjectHandler;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;
import com.queplix.qwoss.gen.CustomerObjectHandler;
import com.queplix.qwoss.gen.EmployeeObjectHandler;

/**
 * Store some help functions.
 */
public class ApplicationHelper {

    // Logger.
    protected static AbstractLogger logger = Log.getLog(ApplicationHelper.class);
    // Cache object manager
    private static final CacheObjectManager com = new CacheObjectManager();

    public static final String EMPLOYEE_KEY = "employee";

    /**
     * Set of Object Types.
     */
    public static final Integer INTERACTION_OBJECT_TYPE = 1;
    public static final Integer TICKET_OBJECT_TYPE = 2;
    public static final Integer SOLUTION_OBJECT_TYPE = 3;
    public static final Integer MESSAGE_OBJECT_TYPE = 4;

    public static User loadEmployee(LogonSession ls, Long employeeID)
            throws EQLException {
        if(employeeID == null) {
            return null;
        }
        logger.DEBUG("Try to get data for " + employeeID + " employee");
        User user;
        JEOManagerLocal jeoManager = getJEOManagerLocal();
        UserObject userObj = EmployeeObjectHandler.selectUserByEmployeeID(jeoManager, ls, employeeID);
        user = new User();
        user.setUserID(userObj.getPkey());
        user.setUserType(userObj.getUser_type());
        user.setLoginName(userObj.getLoginname());
        user.setFullName(userObj.getFullname());
        user.setEmail(userObj.getEmail());
        user.setPasswordDigest(userObj.getPassword());
        logger.DEBUG("Got employee for " + employeeID + " : " + user.getLoginName());
        return user;
    }

    public static String loadCustomerMail(LogonSession ls, Long customerID)
            throws EQLException {
        if(customerID == null) {
            return null;
        }
        logger.DEBUG("Try to get mail for " + customerID + " customer");
        EQLManagerLocal eqlManager = getEQLManagerLocal();
        String mailAdr = CustomerObjectHandler.selectMailByID(eqlManager, ls, customerID);
        logger.DEBUG("Got mail for customer # " + customerID + ": " + mailAdr);
        return mailAdr;
    }

    protected static JEOManagerLocal getJEOManagerLocal() {
        return (JEOManagerLocal) com.getLocalObject(JNDINames.JEOManager,
                JEOManagerLocalHome.class);
    }

    protected static EQLManagerLocal getEQLManagerLocal() {
        return (EQLManagerLocal) com.getLocalObject(JNDINames.EQLManager,
                EQLManagerLocalHome.class);
    }


}
