/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.utils;

/**
 * Description.
 *
 * @author rustem.nizamiev
 * @since 18  2007 ., 16:58
 */
public final class TicketHelper {

    // =============================================================== Constants

    // Ticket statuses.
    public static final int NEW_STATUS = 0;
    public static final int ASSIGNED_STATUS = 1;
    public static final int OWNED_STATUS = 2;
    public static final int RELEASE_CANDIDATE_STATUS = 3;
    public static final int DELIVERED_STATUS = 4;
    public static final int UNREPRODUCIBLE_STATUS = 5;
    public static final int CLIENT_ISSUE_STATUS = 6;
    public static final int DUPLICATE_STATUS = 7;
    public static final int PARKED_STATUS = 8;
    public static final int TESTFAIL_STATUS = 9;
    public static final int CLOSED_STATUS = 10;

    // Ticket sources.
    public static final int EMAIL_SRC = 0;
    public static final int PHONE_SRC = 1;
    public static final int FAX_SRC = 2;
    public static final int VOICE_MAIL_SRC = 3;
    public static final int WALK_UP_SRC = 4;
    public static final int SELF_SRC = 5;
    public static final int OTHER_SRC = 6;

    // TICKET priorities.
    public final static int LOW_PRIORITY = 3;
    public final static int MODERATE_PRIORITY = 2;
    public final static int SERIOUS_PRIORITY = 1;
    public final static int CRITICAL_PRIORITY = 0;

    // TICKET reason code
    public final static int RC_OTHER = 9;

    // Ticket origins.
    public final static int EMAIL_ORIGIN = 0;
    public final static int PHONE_ORIGIN = 1;
    public final static int FAX_ORIGIN = 2;
    public final static int VOICE_MAIL_ORIGIN = 3;
    public final static int WALK_UP_ORIGIN = 4;
    public final static int SELF_ORIGIN = 5;
    public final static int CUSTOMER_PORTAL_ORIGIN = 6;

    public final static String ORIGIN_INTERACTION_FIELD = "qw_cur_interaction";
    public final static String TICKET_ID_FIELD = "qw_ticketid";

    // Ticket form.
    public final static String FORM_NAME
            = "eservice__ticket__ticket__ticket.ticket";

    /**
     * Agent property.
     */
    public static final String AGENT_PROPERTY = "DEFAULT_AGENT";
    /**
     * Customer property.
     */
    public static final String CUSTOMER_PROPERTY = "UNKNOWN_CUSTOMER";

    // ================================================================= Methods    
    /**
     * Creates a new instance of TicketHelper
     */
    public TicketHelper() {
    }

}
