/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.app.rpc;

import com.google.gwt.user.client.rpc.RemoteService;
import com.queplix.core.client.app.rpc.RPCException;
import com.queplix.core.client.app.vo.EmailComposeRequestObject;
import com.queplix.core.client.app.vo.EmailComposeResponseObject;

import java.util.Collection;


/**
 * Provides application custom RPC methods.
 *
 * @author Sultan Tezadov
 * @since 12 Feb 2007
 */
public interface CustomService extends RemoteService {

    public Boolean createTicketInteractionLink(Long ticketID, Long interID)
            throws RPCException;

    public Boolean createAttachmentSolutionLink(Long atachmentId,
                                                Long solutionId)
            throws RPCException;

    public Boolean createAttachmentTicketLink(Long atachmentId, Long ticketId)
            throws RPCException;

    public String checkEmailAccount(Long accountPkey, String accountName)
            throws RPCException;

    public Boolean startTask(Long taskID) throws RPCException;

    public Boolean stopTask(Long taskID) throws RPCException;

    public EmailComposeResponseObject sendReply(
            EmailComposeRequestObject request, int objectType, long objectId)
            throws RPCException;

    public String getAccountReplyEmail(Long accountId) throws RPCException;

    public String[] getFromAndToEmail(int objectType, long objectId,
                                      boolean isCustomer, Long initCustomer)
            throws RPCException;

    public Boolean deleteInbox(Collection inboxPkey) throws RPCException;

    public Boolean deleteAttachment(Collection attachmentPkeys)
            throws RPCException;
}
