/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.app.rpc;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.queplix.core.client.app.vo.EmailComposeRequestObject;

import java.util.Collection;

/**
 * Provides application custom RPC methods.
 *
 * @author Sultan Tezadov
 * @since 12 Feb 2007
 */
public interface CustomServiceAsync {
    public void createTicketInteractionLink(Long ticketID, Long interID,
                                            AsyncCallback callback);

    public void createAttachmentSolutionLink(Long atachmentId, Long solutionId,
                                             AsyncCallback callback);

    public void createAttachmentTicketLink(Long atachmentId, Long ticketId,
                                           AsyncCallback callback);

    public void checkEmailAccount(Long accountPkey, String accountName,
                                  AsyncCallback callback);

    public void startTask(Long taskID, AsyncCallback callback);

    public void stopTask(Long taskID, AsyncCallback callback);

    public void sendReply(EmailComposeRequestObject request, int objectType,
                          long objectId, AsyncCallback callback);

    public void getAccountReplyEmail(Long accountId, AsyncCallback callback);

    public void getFromAndToEmail(int objectType, long objectId,
                                  boolean isCustomer, Long initCustomerId,
                                  AsyncCallback callback);

    public void deleteInbox(Collection inboxPkey, AsyncCallback callback);

    public void deleteAttachment(Collection attachmentPkeys,
                                 AsyncCallback callback);

}
