/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.vo.EntityReferenceDataRequest;
import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.FieldDataRequest;
import com.queplix.core.client.frames.mainframe.DefaultOperationStrategy;

/**
 * In general, this class is created to add additional filters to "Object id" entity reference.
 *
 * @author Sergey Kozmin
 * @since 29.01.2007
 */
class PermissionSecurityStrategy extends OSSOperationStrategy {
    public static final String OBJECT_ID_FIELD_NAME = "object_id";
    public static final String OBJECT_TYPE_FIELD_NAME
            = "permission_object_type";//field name in this entity
    public static final String FILTER_FIELD_NAME
            = "type";//field name in entity, where this entityReference is referencing.

    protected boolean processControlDataRequest(FieldDataRequest request) {
        if (OBJECT_ID_FIELD_NAME.equalsIgnoreCase(request.getElementID())) {
            EntityReferenceDataRequest theRequest
                    = (EntityReferenceDataRequest) request;
            FieldData data = getOperationContext().getFormOperations()
                    .getFieldData(
                            getFormIndex(), OBJECT_TYPE_FIELD_NAME);
            FieldData cloned = data.cloneData();
            cloned.setFieldID(FILTER_FIELD_NAME);
            theRequest.setAdditionalFilterForRequestingEntity(cloned);
        }
        return super.processControlDataRequest(request);
    }
}
