/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.server.app.rpc;

import com.queplix.core.client.app.rpc.DisplayableException;
import com.queplix.core.modules.inbox.Account;
import com.queplix.core.modules.inbox.error.InvalidAccountException;
import com.queplix.core.modules.inbox.utils.AccountDAO;
import com.queplix.core.modules.inbox.utils.InboxPropertyFactory;
import com.queplix.core.modules.inbox.utils.InboxProvider;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;

/**
 * The class contains RPC source logic of Inbox and Account functionality.
 *
 * @author Konstantin Mironov
 * @since 13 Feb 2007
 */
public class AccountHelper {

    // Logger reference.
    private static final AbstractLogger logger = Log.getLog(
            AccountHelper.class);

    /**
     * The method checks an account if it is valid or not
     *
     * @param accountPkey account id
     * @param accountName accounr name
     * @return TRUE - is valid, FALSE - isn't valid
     * @throws DisplayableException RPC exception
     */
    public static String checkEmailAccount(
            Long accountPkey,
            String accountName
    ) throws DisplayableException {

        Account account = null;
        InboxProvider provider;
        logger.INFO("Start check Account:");
        logger.INFO("       ID - " + accountPkey);
        logger.INFO("       name - " + accountName);
        String resultStr = null;
        try {
            AccountDAO dao = InboxPropertyFactory.getInstance().getAccountDAO();
            account = dao.loadAccountVO(accountPkey.longValue());
            if(account == null) {
                throw new NullPointerException(
                        "Account #" + accountName + " not found!");
            } // if (account == null)
            Class providerClass = InboxPropertyFactory.getInstance()
                    .getInboxProviderClass(account.getProviderName());
            provider = (InboxProvider) InboxPropertyFactory.getInstance().
                    getInstance(providerClass, account, "[Account#test]", null);
            provider.checkAccount();
            account.setValidFlag(Boolean.TRUE);

            logger.INFO("Finish check Account. Account is valid.");
        } catch (InvalidAccountException ex) {
            // Mark account as invalid.
            try {
                account.setValidFlag(Boolean.FALSE);
            } catch (Exception ex2) {
                logger.ERROR("Cannot update account state!", ex2);
            } // try
            logger.INFO("Finish check Account. Account isn't valid");
            resultStr = ex.getMessage();
            return resultStr;
        } // try
        return resultStr;
    } // checkEmailAccount(Long, String) : String
} // class AccountHelper