/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.server.app.rpc;

import com.queplix.core.client.app.rpc.DisplayableException;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.WebLoginManager;
import com.queplix.core.modules.config.utils.SysPropertyManager;
import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.ejb.EQLManagerLocalHome;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;
import com.queplix.qwoss.gen.CustomerObjectHandler;
import com.queplix.qwoss.gen.EmployeeObjectHandler;
import com.queplix.qwoss.gen.InteractionTicketObject;
import com.queplix.qwoss.gen.InteractionTicketObjectHandler;

import javax.servlet.http.HttpServletRequest;

/**
 * Application custom RPC methods implementation.
 *
 * @author rnizamiev
 * @since 12 Feb 2007
 */

public class TicketLinkRPCHelper {
    // Logger reference.
    private static final AbstractLogger logger = Log.getLog(
            TicketLinkRPCHelper.class);
    private static final String DEFAULT_SENDER = "DEFAULT_SENDER";

    public static String[] getFromAndToEmail(int objectType, long objectId,
                                             boolean isCustomer,
                                             Long initCustomerId,
                                             HttpServletRequest request)
            throws DisplayableException, EQLException {
        LogonSession ls = WebLoginManager.getLogonSession(request);
        EQLManagerLocal eqlManager = (EQLManagerLocal)
                new CacheObjectManager().getLocalObject(JNDINames.EQLManager,
                        EQLManagerLocalHome.class);
        String toMail = "";
        if(isCustomer) // CustomerObject 
        {
            toMail = CustomerObjectHandler.selectMailByID(eqlManager, ls,
                    initCustomerId.longValue());
        } else // EmployeeObject
        {
            toMail = EmployeeObjectHandler.selectMailByID(eqlManager, ls,
                    initCustomerId.longValue());
        }
        if(toMail == null) {
            toMail = "";
        }
        String fromMail = SysPropertyManager.getProperty(DEFAULT_SENDER);
        String eqlQuery = "select account.reply_email where inbox.object_type="
                + objectType +
                " and inbox.object_id=" + objectId;
        EQLRes eqlRes = eqlManager.select(ls, eqlQuery);
        //int cnt = eqlManager.selectCount( ls, eqlRes );
        if(eqlManager.selectCount(ls, eqlRes) > 0) {
            fromMail = eqlRes.getRecord(0).getResCell(0).getString();
        }
        String[] retValues = {
                fromMail,
                toMail
        };
        return retValues;
    }


    public static Boolean createTicketInteractionLink(Long ticketID,
                                                      Long interID,
                                                      HttpServletRequest request)
            throws DisplayableException, EQLException {
        LogonSession ls = WebLoginManager.getLogonSession(request);
        JEOManagerLocal jeoManager = (JEOManagerLocal)
                new CacheObjectManager().getLocalObject(JNDINames.JEOManager,
                        JEOManagerLocalHome.class);
        logger.INFO("createTicketInteractionLink: Ticket # " + ticketID
                + " is going to be linked to interaction # " + interID);
        InteractionTicketObjectHandler interHnd;
        interHnd = (InteractionTicketObjectHandler)
                InteractionTicketObjectHandler.selectByIDs(jeoManager, ls,
                        ticketID.longValue(), interID.longValue());
        if(interHnd == null) { //there is no duplicate link
            JEObjectHandler linkHnd = jeoManager.create(ls,
                    InteractionTicketObjectHandler.class);
            InteractionTicketObject linkObj = (InteractionTicketObject) linkHnd
                    .getJEObject();
            linkObj.setQw_interactionid(interID);
            linkObj.setQw_ticketid(ticketID);
            jeoManager.commit(linkHnd);
            logger.INFO("createTicketInteractionLink: Link for Interaction # "
                    + interID + " and Ticket # " + ticketID + " is created.");
            return Boolean.TRUE;
        } else {
            logger.WARN(
                    "createTicketInteractionLink: The link already exists.");
            return Boolean.FALSE;
        }
    }


}