/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.utils;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.integrator.IntegratorHelper;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;
import com.queplix.qwoss.gen.EmployeeObject;
import com.queplix.qwoss.gen.EmployeeObjectHandler;

import javax.servlet.ServletContext;

public final class EmployeeHelper {

    private static final AbstractLogger logger = Log.getLog(
            EmployeeHelper.class);

    // ================================================================= Methods    
    /**
     * Creates a new instance of EmployeeHelper
     */
    public EmployeeHelper() {
    }

    public static EmployeeObject getEmployeeByUserID(LogonSession ls,
                                                     ServletContext ctx) {
        // Initialization.
        JEOManagerLocal jeoManager = IntegratorHelper.getActionContext(ctx)
                .getJEOManager();
        long userID = ls.getUser().getUserID();
        EmployeeObject employee;

        try {
            employee = EmployeeObjectHandler.selectByUserID(jeoManager, ls,
                    userID);
        } catch (EQLException e) {
            logger.ERROR("EQLException: " + e.getMessage(), e);
            throw new GenericSystemException("EQLException: " + e.getMessage());
        }
        return employee;
    }
}
