<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="/">
		<html>
		<head>
			<link rel="stylesheet" href="/style/main.css" type="text/css"/>
			<script src="/js/modules/focus/mainmenu.js"></script>
		</head>
		<body class="mainmenu">
			<xsl:attribute name="onload">
				<xsl:text disable-output-escaping="yes">init(&apos;</xsl:text>
				<xsl:choose>
					<xsl:when test="//tab[@active='true'] = true()">
						<xsl:value-of select="//tab[@active='true']/@name" disable-output-escaping="yes"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="//tab[1]/@name" disable-output-escaping="yes"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text disable-output-escaping="yes">&apos;)</xsl:text>
			</xsl:attribute>
			<div id="mainTab">
				<xsl:apply-templates/>
			</div>
		</body>
		</html>
	</xsl:template>

	<xsl:template match="//tab">
		<xsl:element name="button">
			<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="@caption"/></xsl:attribute>
			<xsl:attribute name="class">passiveMainTab</xsl:attribute>
			<xsl:attribute name="onclick">parent.activateMainTab(this.id)</xsl:attribute>
			<xsl:value-of select="@caption"/>
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
