DROP TABLE dbo.QX_TASK_PARAM
go
DROP TABLE dbo.QX_TASK
go
DROP TABLE dbo.QX_SCRIPT_PARAM
go
DROP TABLE dbo.QX_SCRIPT_PARAM_TYPES
go
DROP TABLE dbo.QX_SCRIPT
go

CREATE TABLE dbo.QX_SCRIPT (
  SCRIPT_ID            INT           NOT NULL,
  SCRIPT_NAME          VARCHAR(255)  NOT NULL,
  SCRIPT_DESCRIPTION   VARCHAR(1022) NULL,
  SCRIPT_CLASS_NAME    VARCHAR(255)  NOT NULL,
  CREATOR_ID           INT           NOT NULL,
  DATE_MODIFIED        DATETIME      NOT NULL,
constraint PK_QX_SCRIPT primary key (SCRIPT_ID)
)
go

create unique index IDX_QX_SCRIPT_NAME       on dbo.QX_SCRIPT (SCRIPT_NAME)
create unique index IDX_QX_SCRIPT_CLASS_NAME on dbo.QX_SCRIPT (SCRIPT_CLASS_NAME)
go

create index IDX_QX_SCRIPT_CREATOR      on dbo.QX_SCRIPT (CREATOR_ID)
go

create table dbo.QX_TASK (
  TASK_ID             INT           NOT NULL,
  TASK_NAME           VARCHAR(255)  NOT NULL,
  TASK_STATUS_ID      INT           NOT NULL,
  SCRIPT_ID           INT           NOT NULL,
  CREATOR_ID          INT           NOT NULL,
  DATE_CREATED        DATETIME      NOT NULL,
  FIRST_START         DATETIME,
  NEXT_START          DATETIME,
  REPEAT              NUMERIC(2)    DEFAULT 0,
  AUTO_START          NUMERIC(2)    DEFAULT 0,
  DELAY               INT,
  TASK_DELAYUNIT_ID   INT,
  LOG_PROCESS_ID      BIGINT,
constraint PK_QX_TASK primary key (TASK_ID),
constraint FK_QX_TASK_QX_TASK_STATUS  foreign key (TASK_STATUS_ID)    references QX_TASK_STATUS (TASK_STATUS_ID),
constraint FK_QX_TASK_QX_TDU          foreign key (TASK_DELAYUNIT_ID)    references QX_TASK_DELAYUNIT (TASK_DELAYUNIT_ID),
constraint FK_QX_TASK_QX_SCRIPT       foreign key (SCRIPT_ID)        references QX_SCRIPT (SCRIPT_ID)
)
go

create index IDX_QX_TASK_CREATOR      on dbo.QX_TASK (CREATOR_ID)
create index IDX_QX_TASK_STATUS       on dbo.QX_TASK (TASK_STATUS_ID)
create index IDX_QX_TASK_DELAYUNIT    on dbo.QX_TASK (TASK_DELAYUNIT_ID)
create index IDX_QX_TASK_SCRIPT       on dbo.QX_TASK (SCRIPT_ID)
go

UPDATE QX_SYS_PROP SET PROP_VAL = '029' WHERE (PROP_ID = 'DB_CORE_VERSION');
GO