/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;


/**
 * MetaData container for chart field.
 *
 * @author Michael Trofimov
 */
public class ChartFieldMeta extends BaseFieldMeta {

	private String chartName;
	private boolean forDashboard = false;
	
	public ChartFieldMeta(String fieldID, String chartName) {
        super(CHART, fieldID, "");
        super.setReadOnly(true);
        super.setSearchable(false);
        super.setRequired(false);
        this.chartName = chartName;
    }

    public ChartFieldMeta(String fieldID, String chartName, boolean forDashboard) {
        this(fieldID, chartName);
        this.forDashboard = forDashboard;
    }
    
    public ChartFieldMeta(String fieldID) {
        this(fieldID, null);
    }

    public ChartFieldMeta() {
        this(null);
    }
    
    public void setReadOnly(boolean readonly) {
    }

    public void setSearchable(boolean searchable) {
    }

    public void setRequired(boolean required) {
    }

	public String getChartName() {
		return chartName;
	}
	
	public boolean isForDashboard() {
		return forDashboard;
	}

}
