/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.queplix.core.client.common.StringUtil;

/**
 * Data container for entity reference field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class EntityReferenceData extends BaseFieldData {
    private Long selectedRowID;
    private String selectedFilter;

    public EntityReferenceData(String fieldID, String selectedFilter,
                               Long selectedRowID) {
        super(fieldID);
        this.selectedFilter = selectedFilter;
        this.selectedRowID = selectedRowID;
    }

    public EntityReferenceData(String fieldID) {
        this(fieldID, "", null);
    }

    public EntityReferenceData() {
        this("");
    }

    public void clear() {
        selectedFilter = null;
        selectedRowID = null;
    }

    public boolean isEmpty() {
        return selectedRowID == null && StringUtil.isStringEmpty(
                selectedFilter);
    }

    public String getSelectedFilter() {
        return selectedFilter;
    }

    public void setSelectedFilter(String selectedFilter) {
        this.selectedFilter = selectedFilter;
    }

    public Long getSelectedRowID() {
        return selectedRowID;
    }

    public void setSelectedRowID(Long selectedRowID) {
        this.selectedRowID = selectedRowID;
    }

    public FieldData cloneData() {
        return new EntityReferenceData(getFieldID(), selectedFilter,
                selectedRowID);
    }

    public boolean dataEqualsTo(FieldData data) {
        boolean ret = false;
        if(data != null && data.getFieldID().equalsIgnoreCase(getFieldID())) {
            //assume that if ids are equal, then control types are equal too (within one form)
            EntityReferenceData castData = (EntityReferenceData) data;

            boolean isRowIdEquals = selectedRowID == null ?
                    (selectedRowID == castData.selectedRowID):
                    selectedRowID.equals(castData.selectedRowID);

            boolean isFiltersEquals = selectedFilter == null ?
                    (selectedFilter == castData.selectedFilter):
                    selectedFilter.equals(castData.selectedFilter);

            ret = isRowIdEquals && isFiltersEquals;
        }
        return ret;
    }
}
