/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import java.util.Map;

/**
 * On demand data container for entity reference field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class EntityReferenceOnDemandData extends BaseFieldOnDemandData {
    private GridData data;
    /**
     * Contains rendering value, indexed by rowID attribute. Map<Long, String>();
     */
    private Map renderingValues;
    private int totalRecordsNumber;
    private int currentPage;

    public EntityReferenceOnDemandData(String fieldID, GridData data,
                                       Map renderingValues,
                                       int totalRecordsNumber,
                                       int currentPage) {
        super(fieldID);
        this.data = data;
        this.renderingValues = renderingValues;
        this.totalRecordsNumber = totalRecordsNumber;
        this.currentPage = currentPage;
    }

    public EntityReferenceOnDemandData(String fieldID) {
        super(fieldID);
    }

    public EntityReferenceOnDemandData() {
    }

    public GridData getData() {
        return data;
    }

    public void setData(GridData data) {
        this.data = data;
    }

    public int getTotalRecordsNumber() {
        return totalRecordsNumber;
    }

    public void setTotalRecordsNumber(int totalRecordsNumber) {
        this.totalRecordsNumber = totalRecordsNumber;
    }

    public int getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public Map getRenderingValues() {
        return renderingValues;
    }

    public void setRenderingValues(Map renderingValues) {
        this.renderingValues = renderingValues;
    }
}
