/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Represent data for a field.
 *
 * @author Sergey Kozmin
 * @since 13.10.2006, 13:58:51
 */
public interface FieldData extends IsSerializable {
    /**
     * @return unique within form id, that can be used to identify element
     */
    public String getFieldID();

    public void setFieldID(String fieldID);

    /**
     * Clear field data. This action should not lead to null exception.
     */
    public void clear();

    /**
     * @return is data empty
     */
    public boolean isEmpty();

    public FieldData cloneData();

    /**
     * Here we assume, that this method will be used for {@link FieldData}
     * withing single entity object, so type can be determined by using
     * entityId.equalIgnoreCase(anotherEntityId)
     *
     * @param data data to compare
     * @return if two entities are equals
     */
    public boolean dataEqualsTo(FieldData data);
}
