/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;


/**
 * In form grid request for the type {@link #GET_SORTED_DATA}
 *
 * @author Vasily Mikhailitchenko
 * @since 22.05.2007
 */
public class GetSortedDataInformRequest extends InFormDataRequest {
    private SortField sortField;
    /**
     * RowData[] - the rows that are currently present in grid
     */
    private RowData[] rowData;

    public GetSortedDataInformRequest(String elementID, SortField sortField,
                                      String requestingEntity, RowData[] rowData){
        super(elementID, GET_SORTED_DATA, requestingEntity);
        this.sortField = sortField;
        this.rowData = rowData;
    }

    public GetSortedDataInformRequest(){
        this("", null,  "", null);
    }

    public void setSortField(SortField sortField){
        this.sortField = sortField;
    }

    public SortField getSortField(){
        return sortField;
    }

    public void setRowData(RowData[] rowData){
        this.rowData = rowData;
    }

    public RowData[] getRowData(){
        return rowData;
    }
}
