/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.app.vo.util.InvariantDate;

import java.util.Date;

/**
 * Result data for Parse Date request.
 *
 * @author Aliaksandr Melnik
 * @since 22 Nov 2006
 */
public class ParseDateResponseObject implements IsSerializable {
    private InvariantDate startInvDate;
    private InvariantDate endInvDate;
    private boolean isInterval;
    private boolean isSuccessful;

    public ParseDateResponseObject() {
        isInterval = false;
        isSuccessful = false;
    }

    public ParseDateResponseObject(Date date, boolean isSuccessful) {
        setStartDate(date);
        isInterval = false;
        this.isSuccessful = isSuccessful;
    }

    public ParseDateResponseObject(Date startDate, Date endDate,
                                   boolean isSuccessful) {
        setStartDate(startDate);
        setEndDate(endDate);
        isInterval = true;
        this.isSuccessful = isSuccessful;
    }

    public Date getStartDate() {
        return InvariantDate.toDate(startInvDate);
    }

    public void setStartDate(Date startDate) {
        this.startInvDate = InvariantDate.fromDate(startDate);
    }

    public Date getEndDate() {
        return InvariantDate.toDate(endInvDate);
    }

    public void setEndDate(Date endDate) {
        this.endInvDate = InvariantDate.fromDate(endDate);
    }

    public boolean isInterval() {
        return isInterval;
    }

    public boolean isSuccessful() {
        return isSuccessful;
    }

    public void setSuccessful(boolean isSuccessful) {
        this.isSuccessful = isSuccessful;
    }

}
