/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */


package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 *
 * @author dmitry.antonov
 */
public class PortalConfigMeta implements IsSerializable {
    
    public static class MainToolbarMeta implements IsSerializable {
        private String[] controls;
        
        public MainToolbarMeta() {}
        
        public MainToolbarMeta(String[] controls) {
            setControls(controls);
        }
        
        public boolean useDefaultConfig() {
            return controls == null;
        }

        public String[] getControls() {
            return controls;
        }

        public void setControls(String[] controls) {
            this.controls = controls;
        }
        
    }
    
    private boolean showFocusMenu;
    private boolean showSubFocusMenu;
    private String cssFileName;
    private MainToolbarMeta toolbar;
    
    /** Creates a new instance of PortalConfigMeta */
    public PortalConfigMeta() {
    }

    public boolean isShowSubFocusMenu() {
        return showSubFocusMenu;
    }

    public void setShowSubFocusMenu(boolean showSubFocusMenu) {
        this.showSubFocusMenu = showSubFocusMenu;
    }

    public String getCssFileName() {
        return cssFileName;
    }

    public void setCssFileName(String cssFileName) {
        this.cssFileName = cssFileName;
    }

    public MainToolbarMeta getToolbar() {
        return toolbar;
    }

    public void setToolbar(MainToolbarMeta toolbar) {
        this.toolbar = toolbar;
    }

    public boolean isShowFocusMenu() {
        return showFocusMenu;
    }

    public void setShowFocusMenu(boolean showFocusMenu) {
        this.showFocusMenu = showFocusMenu;
    }
    
}
