/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.common.CollectionsHelper;

import java.util.Collection;

/**
 * This class is used to store filters was set in filtering dialog.
 *
 * @author Sergey Kozmin
 * @since 03.04.2007
 */
public class RecordFilter implements IsSerializable {
    public static final Collection EMPTY_COL = CollectionsHelper
            .emptyCollection();
    /**
     * Collection<FieldData>. Collection of the filters for the field.
     * This type of filtering is used when no records was selected.
     */
    private Collection filtersList;
    /**
     * Collection<Long>. Collection of the records was selected in dialog.
     */
    private Collection recordIds;

    public static RecordFilter createRecordsFilter(Collection recordIds) {
        return new RecordFilter(null, recordIds);
    }

    public static RecordFilter createFieldsFilter(Collection filtersList) {
        return new RecordFilter(filtersList, null);
    }

    private RecordFilter(Collection filtersList, Collection recordIds) {
        setFiltersList(filtersList);
        setRecordIds(recordIds);
    }

    public RecordFilter() {
        setFiltersList(null);
        setRecordIds(null);
    }

    public Collection getFiltersList() {
        return filtersList;
    }

    public void setFiltersList(Collection filtersList) {
        if(filtersList != null) {
            this.filtersList = filtersList;
        } else {
            this.filtersList = EMPTY_COL;
        }
    }

    public Collection getRecordIds() {
        return recordIds;
    }

    public void setRecordIds(Collection recordIds) {
        if(recordIds != null) {
            this.recordIds = recordIds;
        } else {
            this.recordIds = EMPTY_COL;
        }
    }

    public boolean isRecordsFilter() {
        return recordIds.size() != 0;
    }

    public boolean isEmpty() {
        return recordIds.size() == 0 && filtersList.size() == 0;
    }
}
