/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author rustem.nizamiev, Sergey Kozmin
 */
public class SearchGridRecordsResponseObject implements IsSerializable {
    private GridData gridData;

    private int totalRecordsCount;
    private int currentPage;

    public SearchGridRecordsResponseObject(GridData gridData,
                                           int totalRecordsCount,
                                           int currentPage) {
        if(gridData != null) {
            this.gridData = gridData;
        } else {
            this.gridData = new GridData();
        }
        this.totalRecordsCount = totalRecordsCount;
        this.currentPage = currentPage;
    }

    public SearchGridRecordsResponseObject() {
        this(null, -1, -1);
    }

    public GridData getGridData() {
        return gridData;
    }

    public void setGridData(GridData gridData) {
        this.gridData = gridData;
    }

    public int getTotalRecordsCount() {
        return totalRecordsCount;
    }

    public void setTotalRecordsCount(int pageCount) {
        this.totalRecordsCount = pageCount;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getCurrentPage() {
        return currentPage;
    }
}
