/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

/**
 * @author aliaksandr.melnik
 * @author Sergey Kozmin
 */
public class SortFieldImpl implements SortField {
    private String fieldID;
    private Boolean sortOrder;

    public SortFieldImpl() {
    }

    /**
     * sortOrder == true - ascending
     * sortOrder == false - descending
     * sortOrder == null - there is no sort order
     */
    public SortFieldImpl(String fieldID, Boolean sortOrder) {
        this.fieldID = fieldID;
        this.sortOrder = sortOrder;
    }

    /**
     * sortOrder == true - ascending
     * sortOrder == false - descending
     * sortOrder == null - there is no sort order
     */
    public SortFieldImpl(String fieldID, boolean sortOrder) {
        this.fieldID = fieldID;
        this.sortOrder = new Boolean(sortOrder);
    }

    public String getFieldID() {
        return fieldID;
    }

    public void setFieldID(String fieldID) {
        this.fieldID = fieldID;
    }

    public Boolean getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Boolean sortOrder) {
        this.sortOrder = sortOrder;
    }

}
