/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo.chart;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.app.vo.FieldData;

/**
 * Represents chart's data item.
 */
public class ChartDataItem implements IsSerializable {

    private String shape;
    private String coords;
    private String title;
    private FieldData fieldData;


    /**
     * GWT serialization constructor
     */
    public ChartDataItem() {
    }

    /**
     * Creates new chart's item
     *
     * @param shape  shape type of item (circle, rectangle or polygon)
     * @param coords shape coordinates as a string
     */
    public ChartDataItem(String shape, String coords) {
        this.shape = shape;
        this.coords = coords;
    }

    /**
     * Creates new chart's item
     *
     * @param shape  shape type of item (circle, rectangle or polygon)
     * @param coords shape coordinates as a string
     * @param title  shape's title
     */
    public ChartDataItem(String shape, String coords, String title) {
        this(shape, coords);
        this.title = title;
    }

    /**
     * Creates new chart's item
     *
     * @param shape     shape type of item (circle, rectangle or polygon)
     * @param coords    shape coordinates as a string
     * @param title     shape's title
     * @param fieldData Category field's {@link com.queplix.core.client.app.vo.FieldData} associated with a shape
     */
    public ChartDataItem(String shape, String coords, String title,
                         FieldData fieldData) {
        this(shape, coords, title);
        this.fieldData = fieldData;
    }

    /**
     * Returns a string describing the type of shape.
     */
    public String getShape() {
        return shape;
    }

    /**
     * Returns the area coordinates as a string.
     */
    public String getCoords() {
        return coords;
    }

    /**
     * Returns the area title.
     */
    public String getTitle() {
        return title;
    }

    /**
     * Returns category field's {@link com.queplix.core.client.app.vo.FieldData}
     * associated with a shape.
     */
    public FieldData getCategoryFieldData() {
        return fieldData;
    }

}
