/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo.chart;

/**
 * Default <code>ChartModel</code> interface implementation.
 * Chart model must contains metadata, chart data is optional.
 *
 * @author Michael Trofimov
 */
public class DefaultChartModel implements ChartModel {

    private ChartMeta meta;
    private ChartData data;

    public DefaultChartModel() {
    }

    public DefaultChartModel(ChartMeta meta) {
        this.meta = meta;
    }

    public DefaultChartModel(ChartMeta meta, ChartData data) {
        this(meta);
        this.data = data;
    }

    public ChartMeta getMeta() {
        return meta;
    }

    public ChartData getData() {
        return data;
    }

}
