/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo.uisettings;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * DialogUISettings.
 *
 * @author Sultan Tezadov
 *         26 Jan 2007
 */
public class DialogUISettings implements IsSerializable {
    private static final int UNSPECIFIED = 0;

    private int left;
    private int top;
    private int width;
    private int height;

    public DialogUISettings() {
    }

    public DialogUISettings(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public int getLeft() {
        return left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getTop() {
        return top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isPositionSet() {
        return (left != UNSPECIFIED) && (top != UNSPECIFIED);
    }

    public boolean isSizeSet() {
        return (width != UNSPECIFIED) && (height != UNSPECIFIED);
    }

}
