/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.common;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.app.vo.FieldData;

import java.util.Collection;
import java.util.Iterator;

/**
 * Due to the fact, that we cant use a lot of java core operations with collection in GWT we create this class to help us.
 *
 * @author Sergey Kozmin
 * @since 29.11.2006, 16:57:23
 */
public class CollectionsHelper {
    private static final EmptyCollection EMPTY_COLLECTION
            = new EmptyCollection();

    public static void copyToArray(Collection srcCol, Object[] destArray) {
        int i = 0;
        for(Iterator iterator = srcCol.iterator(); iterator.hasNext(); i++) {
            destArray[i] = iterator.next();
        }
    }

    public static void copyArrayToCollection(Object[] srcArray,
                                             Collection destCol) {
        for(int i = 0; i < srcArray.length; i++) {
            destCol.add(srcArray[i]);
        }
    }

    public static void copyArrayToCollection(long[] srcArray,
                                             Collection destCol) {
        for(int i = 0; i < srcArray.length; i++) {
            destCol.add(new Long(srcArray[i]));
        }
    }

    public static void arrayCopy(long[] srcArray, Long[] destArray) {
        for(int i = 0; i < srcArray.length; i++) {
            destArray[i] = new Long(srcArray[i]);
        }
    }

    public static void arrayCopy(Long[] srcArray, long[] destArray) {
        for(int i = 0; i < srcArray.length; i++) {
            destArray[i] = srcArray[i].longValue();
        }
    }

    public static void arrayCopy(Object[] srcArray, Object[] destArray) {
        for(int i = 0; i < srcArray.length; i++) {
            destArray[i] = srcArray[i];
        }
    }

    public static FieldData[] delElement(FieldData[] srcArray, int pos) {
        FieldData[] res = new FieldData[srcArray.length - 1];
        int k = 0;
        for(int i = 0; i < srcArray.length; i++) {
            if(i != pos) {
                res[k] = srcArray[i];
                k++;
            }
        }
        return res;
    }

    public static FieldData[] addElement(FieldData[] srcArray) {
        FieldData[] res = new FieldData[srcArray.length + 1];
        arrayCopy(srcArray, res);
        return res;
    }

    public static long[] createIncrementalArray(int lenght, long from) {
        long[] ret = new long[lenght];
        for(int i = 0; i < ret.length; i++) {
            ret[i] = from + i;
        }
        return ret;
    }

    public static Collection emptyCollection() {
        return EMPTY_COLLECTION;
    }

    public static final class EmptyCollection implements Collection,
            IsSerializable {
        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean contains(Object o) {
            return false;
        }

        public Iterator iterator() {
            return new EmptyIterator();
        }

        public Object[] toArray() {
            return new Object[0];
        }

        public boolean add(Object o) {
            throw new IllegalStateException("You couldn't add elements "
                    + "to empty collection.");
        }

        public boolean remove(Object o) {
            return false;
        }

        public boolean addAll(Collection c) {
            throw new IllegalStateException("You couldn't add elements "
                    + "to empty collection.");
        }

        public void clear() {
        }

        public boolean retainAll(Collection c) {
            return false;
        }

        public boolean removeAll(Collection c) {
            return false;
        }

        public boolean containsAll(Collection c) {
            return false;
        }

        public Object[] toArray(Object[] a) {
            return a;
        }
    }

    public static class EmptyIterator implements Iterator, IsSerializable {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }
}
