<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>

	<!-- Global variables {{{ -->
	<!-- if exists, then the report is for export to word and excel -->
	<xsl:param name="EXPORTED_REPORT"/>

	<!-- Report variables -->
	<xsl:variable name="processId" select="/report/@processId"/>
	<xsl:variable name="formTitle" select="/report/reportiter/@iterTitle"/>

	<!-- Page variables -->
	<xsl:variable name="makeHeader" select="/report/reportiter/@isFirst = 'true'"/>
	<xsl:variable name="makeFooter" select="/report/reportiter/@isLast = 'true'"/>

<!-- Header row -->
	<xsl:variable name="headerFontName">
		<xsl:choose>
			<xsl:when test="//headerFontName"><xsl:value-of select="//headerFontName"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Arial'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerFontSize">
		<xsl:choose>
			<xsl:when test="//headerFontSize"><xsl:value-of select="//headerFontSize"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'12'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerForeColor">
		<xsl:choose>
			<xsl:when test="//headerForeColor"><xsl:value-of select="//headerForeColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Black'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerBackColor">
		<xsl:choose>
			<xsl:when test="//headerBackColor"><xsl:value-of select="//headerBackColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'#ADAA9C'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="headerBold" select="//headerBold/text() = 'true'"/>
	<xsl:variable name="headerItalic" select="//headerItalic/text() = 'true'"/>
	
	<!-- Even row -->
	<xsl:variable name="evenFontName">
		<xsl:choose>
			<xsl:when test="//evenFontName"><xsl:value-of select="//evenFontName"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Arial'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenFontSize">
		<xsl:choose>
			<xsl:when test="//evenFontSize"><xsl:value-of select="//evenFontSize"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'12'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenForeColor">
		<xsl:choose>
			<xsl:when test="//evenForeColor"><xsl:value-of select="//evenForeColor"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Black'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="evenBackColor">
		<xsl:value-of select="'White'"/>
	</xsl:variable >
	<xsl:variable name="evenBold" select="//evenBold/text() = 'true'"/>
	<xsl:variable name="evenItalic" select="//evenItalic/text() = 'true'"/>

	<!-- Odd row -->
	<xsl:variable name="oddFontName">
		<xsl:choose>
			<xsl:when test="//oddFontName"><xsl:value-of select="//oddFontName"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'Arial'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable >
	<xsl:variable name="oddFontSize">
		<xsl:value-of select="'12'"/>
	</xsl:variable >
	<xsl:variable name="oddForeColor">
		<xsl:value-of select="'Black'"/>
	</xsl:variable >
	<xsl:variable name="oddBackColor">
		<xsl:value-of select="'#FFFFDD'"/>
	</xsl:variable >
	<xsl:variable name="oddBold" select="//oddBold/text() = 'true'"/>
	<xsl:variable name="oddItalic" select="//oddItalic/text() = 'true'"/>
	

	<xsl:template match="report">
		<xsl:apply-templates select="reportiter/ress"/>
	</xsl:template>

	<xsl:template match="ress">
		<xsl:choose>
			<xsl:when test="$makeHeader">
				<xsl:text disable-output-escaping="yes">	&lt;html&gt;</xsl:text>
				<head>
					<xsl:if test="not($EXPORTED_REPORT)">
						<link rel="stylesheet" href="/style/main.css" type="text/css"/>
						<script src="/js/modules/focus/print/gridpopup.js">1</script>
						<script>
							var processId = <xsl:text>'</xsl:text><xsl:value-of select="$processId"/><xsl:text>'</xsl:text>;
							var transletName = 'form';
						</script>
					</xsl:if>
				</head>
				<xsl:text disable-output-escaping="yes">	&lt;body leftmargin="5" topmargin="5" marginheight="5" marginwidth="5"
				oncontextmenu="showGridMenu(); return false" style="background-color:#FFFFFF"&gt;</xsl:text>
				<xsl:text disable-output-escaping="yes">&lt;table border="0" cellspacing="1" class="gridTable" id="reportGrid"&gt;</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<tr class="unevenRow">
				  <td colspan="2">
					<table cellpadding="0" cellspacing="0" border="0">
						<tr><td>&#160;</td></tr>
						<tr><td>&#160;</td></tr>
						<tr><td>&#160;</td></tr>
					</table>
				  </td>
				</tr>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:apply-templates select="res"/>

		<xsl:if test="$makeFooter">
			<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
			<div id="ordermenu" style="width:100; overflow:visible; position:absolute; visibility:hidden; z-index:100" onMouseOut="outGridMenu()" onMouseOver="overGridMenu()"></div>
			<xsl:text disable-output-escaping="yes">	&lt;/body&gt;&lt;/html&gt;</xsl:text>
		</xsl:if>
	</xsl:template>

	<!--
	
	Fields
	
	-->

	<xsl:template match="res">
		<xsl:apply-templates select="res-record" mode="m1"/>
	</xsl:template>

	<xsl:template match="res-record" mode="m1">
		<tr>
			<xsl:attribute name="style">
				<xsl:value-of select="concat('font-family:', $headerFontName, '; font-size:', $headerFontSize, 'px; color:', $headerForeColor,'; background-color:', $headerBackColor,';font-weight:bold')"/>
				<xsl:text>;font-style:</xsl:text>
				<xsl:choose>
					<xsl:when test="$headerItalic">
						<xsl:text>italic</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>none</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<td colspan="2">
				<xsl:value-of select="$formTitle"/>
			</td>
		</tr>
		<xsl:apply-templates select="res-field" mode="m1"/>
		<xsl:for-each select="ancestor-or-self::*//res-header-dataset">
			<xsl:call-template name="resDataset">
				<xsl:with-param name="name" select="@name"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="res-field" mode="m1">
		<xsl:variable name="name" select="@name"/>
		<xsl:variable name="visible" select="ancestor-or-self::*//ress/res-header/res-header-field[@name = $name]/@visible"/>

		<xsl:if test="$visible = 'true' and not($name = 'history')">
			<xsl:variable name="value">
				<xsl:choose>
					<xsl:when test="res-field-text">
						<xsl:value-of select="res-field-text/text()"/>
					</xsl:when>
					<xsl:when test="res-field-value">
						<xsl:value-of select="res-field-value/text()"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&#160;</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="caption" select="ancestor-or-self::*//ress/res-header/res-header-field[@name = $name]/@caption"/>
			<xsl:variable name="type" select="ancestor-or-self::*//ress/res-header/res-header-field[@name = $name]/@datatype"/>
		
			<tr>
				<xsl:attribute name="style">
					<xsl:text>cursor:pointer; cursor:hand;</xsl:text>
					<xsl:choose>
						<xsl:when test="position() mod 2">
							<xsl:value-of select="concat('background-color:', $oddBackColor, ';color:', $oddForeColor, ';font-family:', $oddFontName,';font-size:', $oddFontSize, ';font-weight:')"/>
							<xsl:choose>
								<xsl:when test="$oddBold">
									<xsl:text>bold</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>none</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:text>;font-style:</xsl:text>
							<xsl:choose>
								<xsl:when test="$oddItalic">
									<xsl:text>italic</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>none</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat('background-color:', $evenBackColor, ';color:', $evenForeColor, ';font-family:', $evenFontName,';font-size:', $evenFontSize, ';font-weight:')"/>
							<xsl:choose>
								<xsl:when test="$evenBold">
									<xsl:text>bold</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>none</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:text>;font-style:</xsl:text>
							<xsl:choose>
								<xsl:when test="$evenItalic">
									<xsl:text>italic</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>none</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<td nowrap="true" width="1%">
					<xsl:value-of select="$caption"/>
				</td>
				<td style="word-wrap:break-word">
					<xsl:call-template name="printFieldValue">
						<xsl:with-param name="type" select="$type"/>
						<xsl:with-param name="value" select="$value"/>
					</xsl:call-template>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>

	<xsl:template name="printFieldValue">
		<xsl:param name="type"/>
		<xsl:param name="value"/>
	
		<xsl:choose>
			<xsl:when test="$type = 'memo'">
				<xsl:choose>
					<xsl:when test="starts-with($value, '&lt;html&gt;')">
						<!-- memo field with HTML -->
						<xsl:value-of disable-output-escaping="yes" select="$value"/>
					</xsl:when>
					<xsl:otherwise>
						<!-- memo field with plain text -->
						<pre style="white-space:normal">
							<xsl:copy-of select="$value"/>
						</pre>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!-- normal field -->
				<xsl:copy-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>					
	</xsl:template>

	<!--
	
	Datasets
	
	-->
	
	<xsl:template name="resDataset">
		<xsl:param name="name"/>
		<tr class="unevenRow">
			<td height="100%" colspan="2">&#160;</td>
		</tr>
		<tr>
			<xsl:attribute name="style">
				<xsl:text>cursor:pointer; cursor:hand;</xsl:text>
				<xsl:choose>
					<xsl:when test="position() mod 2">
						<xsl:value-of select="concat('background-color:', $oddBackColor, ';color:', $oddForeColor, ';font-family:', $oddFontName,';font-size:', $oddFontSize, ';font-weight:')"/>
						<xsl:choose>
							<xsl:when test="$oddBold">
								<xsl:text>bold</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>;font-style:</xsl:text>
						<xsl:choose>
							<xsl:when test="$oddItalic">
								<xsl:text>italic</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('background-color:', $evenBackColor, ';color:', $evenForeColor, ';font-family:', $evenFontName,';font-size:', $evenFontSize, ';font-weight:')"/>
						<xsl:choose>
							<xsl:when test="$evenBold">
								<xsl:text>bold</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>;font-style:</xsl:text>
						<xsl:choose>
							<xsl:when test="$evenItalic">
								<xsl:text>italic</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<td nowrap="true" width="1%">
				<xsl:value-of select="ancestor-or-self::*//res-header-dataset[@name = $name]/@caption"/>
			</td>
			<td style="word-wrap:break-word" width="100%">
				<table border="0" cellspacing="1" class="gridTable" id="reportGrid" width="100%">
					<xsl:apply-templates select="ancestor-or-self::*//res-header-dataset[@name = $name]/res-header" mode="m2">
						<xsl:with-param name="isEmpty" select="not(ancestor-or-self::*//res-dataset[@name = $name]/res-record)"/>
					</xsl:apply-templates>
					<xsl:apply-templates select="ancestor-or-self::*//res-dataset[@name = $name]/res-record" mode="m2">
						<xsl:with-param name="dataset" select="$name"/>
					</xsl:apply-templates>
				</table>
			</td>		
		</tr>
	</xsl:template>

	<xsl:template match="res-record" mode="m2">
		<xsl:param name="dataset"/>

		<tr id="{@id}">
			<xsl:attribute name="style">
				<xsl:text>cursor:pointer; cursor:hand;</xsl:text>
				<xsl:choose>
					<xsl:when test="position() mod 2">
						<xsl:value-of select="concat('background-color:', $oddBackColor, ';color:', $oddForeColor, ';font-family:', $oddFontName,';font-size:', $oddFontSize, ';font-weight:')"/>
						<xsl:choose>
							<xsl:when test="$oddBold">
								<xsl:text>bold</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>;font-style:</xsl:text>
						<xsl:choose>
							<xsl:when test="$oddItalic">
								<xsl:text>italic</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('background-color:', $evenBackColor, ';color:', $evenForeColor, ';font-family:', $evenFontName,';font-size:', $evenFontSize, ';font-weight:')"/>
						<xsl:choose>
							<xsl:when test="$evenBold">
								<xsl:text>bold</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text>;font-style:</xsl:text>
						<xsl:choose>
							<xsl:when test="$evenItalic">
								<xsl:text>italic</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>none</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates select="res-field" mode="m2">
				<xsl:with-param name="dataset" select="$dataset"/>
			</xsl:apply-templates>
		</tr>
	</xsl:template>

	<xsl:template match="res-header" mode="m2">
		<xsl:param name="isEmpty"/>
		<tr>
			<xsl:attribute name="style">
				<xsl:value-of select="concat('font-family:', $headerFontName, '; font-size:', $headerFontSize, 'px; color:', $headerForeColor,'; background-color:', $headerBackColor,';font-weight:bold')"/>
				<xsl:text>;font-style:</xsl:text>
				<xsl:choose>
					<xsl:when test="$headerItalic">
						<xsl:text>italic</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>none</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates select="res-header-field" mode="m2"/>
		</tr>
		<xsl:if test="$isEmpty">
			<tr id="0" class="evenRow">
				<xsl:apply-templates select="res-header-field" mode="m3"/>				
			</tr>
		</xsl:if>
	</xsl:template>

	<!-- comments: normal header-->
	<xsl:template match="res-header-field" mode="m2">
		<xsl:if test="@visible = 'true'">
			<td style="white-space:nowrap;">
				<xsl:choose>
					<xsl:when test="@caption">
						<xsl:value-of select="@caption"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat(@entity, '__', @name)"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</xsl:if>		
	</xsl:template>

	<!-- comments: empty header-->
	<xsl:template match="res-header-field" mode="m3">
		<xsl:variable name="name" select="@name"/>
		<xsl:if test="@visible = 'true'">
			<td>&#160;</td>
		</xsl:if>		
	</xsl:template>


	<xsl:template match="res-field" mode="m2">
		<xsl:param name="dataset"/>

		<xsl:variable name="name" select="@name"/>
		<xsl:variable name="visible" select="ancestor::*//res-header-dataset[@name = $dataset]/res-header/res-header-field[@name = $name]/@visible"/>

		<xsl:if test="$visible = 'true' and not($name = 'history')">
			<xsl:variable name="type" select="ancestor::*//res-header-dataset[@name = $dataset]/res-header/res-header-field[@name = $name]/@datatype"/>
			<xsl:variable name="value">
				<xsl:choose>
					<xsl:when test="res-field-text">
						<xsl:value-of select="res-field-text/text()"/>
					</xsl:when>
					<xsl:when test="res-field-value">
						<xsl:value-of select="res-field-value/text()"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&#160;</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<td style="word-wrap:break-word">
				<xsl:call-template name="printFieldValue">
					<xsl:with-param name="type" select="$type"/>
					<xsl:with-param name="value" select="$value"/>
				</xsl:call-template>
			</td>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
