/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.integrator.security;

/**
 * Object that describe access right for some object.
 *
 * @author Sergey Kozmin
 * @since 16.01.2007
 */
public class Permission {
    private PermissionObjectType objectType;
    private AccessLevel level;
    private String objectID;

    Permission(PermissionObjectType objectType, AccessLevel level,
               String objectID) {
        this.objectType = objectType;
        this.level = level;
        this.objectID = objectID;
    }

    public PermissionObjectType getObjectType() {
        return objectType;
    }

    public AccessLevel getLevel() {
        return level;
    }

    public void setLevel(AccessLevel level) {
        this.level = level;
    }

    public String getObjectID() {
        return objectID;
    }
}
