/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.alert;

import java.util.Date;
import java.util.List;

/**
 * Interface represents the information for a alert record.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:07 $
 */

public interface Alert
        extends java.io.Serializable {

    /**
     * Alert ID geter
     *
     * @return Long
     */
    long getAlertID();

    /**
     * Alert creator (user) ID getter.
     *
     * @return long
     */
    long getCreatorID();

    /**
     * Alert creator (user) type getter.
     *
     * @return int
     */
    int getCreatorType();

    /**
     * Alert sender (user) ID getter.
     *
     * @return long
     */
    long getSenderID();

    /**
     * Alert sender (user) type getter.
     *
     * @return int
     */
    int getSenderType();

    /**
     * Recipient (user) ID getter.
     *
     * @return Long
     */
    Long getRecipientID();

    /**
     * Recipient (user) type getter.
     *
     * @return Integer
     */
    Integer getRecipientType();

    /**
     * Recipient (workgroup) ID getter.
     *
     * @return Long
     */
    Long getWorkgroupID();

    /**
     * Recipient (workgroup) tier getter.
     *
     * @return Integer
     */
    Integer getTier();

    /**
     * 'Send to All' flag getter.
     *
     * @return boolean
     */
    boolean isToAll();

    /**
     * Alert message getter.
     *
     * @return String
     */
    String getMessage();

    /**
     * Alert severity getter.
     *
     * @return int
     */
    int getSeverity();

    /**
     * Data getter.
     *
     * @return AlertData
     */
    AlertData getData();

    /**
     * Date created (posted) getter.
     *
     * @return Date
     */
    Date getDateposted();

    /**
     * Blocks getter.
     *
     * @return List of {@link AlertBlock} objects
     */
    List getBlocks();
}
