/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.alert;

import com.queplix.core.modules.config.jxb.Form;
import com.queplix.core.modules.config.utils.EntityHelper;
import com.queplix.core.modules.eql.CompoundKey;

/**
 * Add-on Alert data.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:07 $
 * @see Alert
 */

public final class AlertData
        implements java.io.Serializable {

    private String focusID;
    private String tabID;
    private String formID;
    private CompoundKey recordKey;

    //
    // Constructors.
    //

    public AlertData(Form _form,
                     CompoundKey _recordKey) {

        this(EntityHelper.getParentFocusName(_form.getTab()),
                _form.getTab(),
                _form.getName(),
                _recordKey);
    }

    public AlertData(String _focusID,
                     String _tabID,
                     String _formID,
                     CompoundKey _recordKey) {

        focusID = _focusID;
        tabID = _tabID;
        formID = _formID;
        recordKey = _recordKey;
    }

    /**
     * Focus ID getter.
     *
     * @return String
     */
    public String getFocusID() {
        return focusID;
    }

    /**
     * Tab ID getter.
     *
     * @return String
     */
    public String getTabID() {
        return tabID;
    }

    /**
     * Form ID getter.
     *
     * @return String
     */
    public String getFormID() {
        return formID;
    }

    /**
     * Record key getter.
     *
     * @return CompoundKey
     */
    public CompoundKey getRecordKey() {
        return recordKey;
    }

    /*
     * No javadoc
     * @see Object#toString
     */
    public String toString() {
        return "focusID=" + focusID +
                "; tabID=" + tabID +
                "; formID=" + formID +
                "; recordKey=[" + recordKey + "]";
    }

}
