/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.attachment.update.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.jeo.gen.AttachmentObject;
import com.queplix.core.modules.jeo.gen.AttachmentObjectHandler;
import com.queplix.core.modules.jeo.gen.AttachmentTempObject;
import com.queplix.core.modules.jeo.gen.AttachmentTempObjectHandler;
import com.queplix.core.utils.JNDINames;

import java.util.List;

/**
 * Description:
 *
 * @author Sergei Savchuk
 */
public class AttachmentUpdate extends EntityUpdate {

    //public static final String SERVER_FILE_NAME = "server_filename";
    //public static final String ATTACHMENT_ID = "attachment_id";

    public int beforeUpdate() throws EQLException {
        // Initialization.
        /*JEOManagerLocal jeoManager = (JEOManagerLocal)
                getCOM().getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);

        // Get current ticket record.
        JEObjectHandler hnd = getJEOHandler(jeoManager, AttachmentObjectHandler.class);
        AttachmentObject attachObj = (AttachmentObject) hnd.getJEObject();

        String serverFileName = getCell(SERVER_FILE_NAME).getString();
        if (serverFileName != null) {
            String path = FileManager.getFSDirectory().getPath();
            path = path + File.separator + serverFileName + "." + attachObj.getFileext();
            File file = new File(path);
            try {
                attachObj.setData(FileHelper.loadFile(file));
                FileHelper.deleteFile(file);
            } catch (IOException e) {
                throw new GenericSystemException("Can't read file: " + file.getName());
            }
        }
        return CONTINUE;*/
        // Initialization.
        JEOManagerLocal jeoManager = (JEOManagerLocal) getCOM().
                getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);
        LogonSession ls = getEUO().getSession().getLogonSession();

        // Get current attachment record.
        JEObjectHandler attHnd = getJEOHandler(jeoManager,
                AttachmentObjectHandler.class);
        AttachmentObject attObj = (AttachmentObject) attHnd.getJEObject();

        // Get the attachment ID.
        long attachID = attObj.getAttachment_id().longValue();

        // Get the process ID.
        Long l = attObj.getProcess_id();
        if(l == null || l.longValue() < 0) {
            //DEBUG( "Process ID is not set for attachment with ID = " + attachID );
            //return CONTINUE;
            throw new NullPointerException(
                    "Process ID is not set for attachment with ID = "
                            + attachID);
        }
        long processID = l.longValue();

        DEBUG("Attachment ID: " + attachID);
        DEBUG("Process ID: " + processID);

        // Get the temporary attachment(s) by the process ID.
        List tmpHnds = AttachmentTempObjectHandler.selectByProcessID(jeoManager,
                ls, processID);
        if(tmpHnds == null || tmpHnds.isEmpty()) {
            DEBUG("No temporary attachments found for process ID = " + processID
                    + " - custom update skipped.");
            return CONTINUE;
        }

        // Found some...
        if(tmpHnds.size() > 1) {
            WARN("Too many temporary attachments for the process ID = "
                    + processID + " - extra ignored.");
        }
        AttachmentTempObjectHandler tmpHnd
                = (AttachmentTempObjectHandler) tmpHnds.get(0);
        AttachmentTempObject tmpObj = (AttachmentTempObject) tmpHnd
                .getJEObject();

        // Update a regular attachment from the temporary.
        attObj.setFilename(tmpObj.getFilename());
        attObj.setFiletype(tmpObj.getFiletype());
        attObj.setFileext(tmpObj.getFileext());
        attObj.setData(tmpObj.getData());
        attObj.setUser_id(tmpObj.getUser_id());
        //attObj.setUser_type_id( tmpObj.getUser_type_id() );

        // Delete the temp attachment used.
        tmpHnd.remove();
        tmpHnd.commit();

        // Ok.
        return CONTINUE;

    }
}
