/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.config.ejb;

import com.queplix.core.modules.config.jxb.ExternalField;
import com.queplix.core.modules.config.jxb.ExternalSet;
import com.queplix.core.modules.config.jxb.Focus;
import com.queplix.core.modules.config.jxb.Form;
import com.queplix.core.modules.config.jxb.SubFocus;
import com.queplix.core.modules.config.jxb.Tab;

import java.util.Collection;
import java.util.List;

/**
 * FocusConfigManager local interface.
 *
 * @author [ALB] Baranov Andrey
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:15 $1
 */

public interface FocusConfigManagerLocal
        extends javax.ejb.EJBLocalObject {

    Focus getFocus(String focusName);

    SubFocus getSubFocus(String subFocusName);

    Tab getTab(String tabName);

    Form getForm(String formName);

    Collection<Focus> getFocuses();

    Collection<Focus> getLocalizedFocuses(String langID);

    Focus getLocalizedFocus(String langID, String focusName);

    SubFocus getLocalizedSubFocus(String langID, String subFocusName);

    Tab getLocalizedTab(String langID, String tabName);

    Form getLocalizedForm(String langID, String formName);

    /**
     * Fast method, but doesn't allow to change values
     *
     * @param formId form to get external set
     * @return array of external sets for the given form or null if there is no
     *         such form
     */
    List<ExternalSet> getUnmodifiableExternalSet(String formId);

    /**
     * Fast method, but doesn't allow to change values
     *
     * @param formId form to get external fields
     * @return array of external fields for the given form or null if there is no
     *         such form
     */
    List<ExternalField> getUnmodifiableExternalFields(String formId);
}
