/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.config.utils;

/**
 * <p>Caption compound key</p>
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:15 $
 */
@Deprecated
public class CaptionID
        implements java.io.Serializable, Comparable {

    // =============================================================== Fields

    private String id;
    private Integer type;

    // =============================================================== Initialization

    /**
     * Creates a new captionVO.
     *
     * @param id   caption ID
     * @param type caption type ID
     */
    public CaptionID(String id, Integer type) {
        this.id = id;
        this.type = type;
    }

    // =============================================================== Inherited methods

    /*(non-Javadoc)
     * @see Comparable#compareTo()
     */

    public int compareTo(Object o) {

        if(o == this) {
            return 0;
        }

        CaptionID c = (CaptionID) o;
        if(id.equals(c.id)) {
            return type.compareTo(c.type);
        } else {
            return id.compareTo(c.id);
        }
    }

    /*(non-Javadoc)
     * @see Object#hashCode()
     */
    public int hashCode() {
        return id.hashCode() | (type.hashCode() << 37);
    }

    /*(non-Javadoc)
     * @see Object#equals(Object)
     */
    public boolean equals(Object obj) {

        if(obj == null || !(obj instanceof CaptionID)) {
            return false;
        }

        CaptionID c = (CaptionID) obj;
        return c.id.equals(id) && c.type.equals(type);
    }

    /*(non-Javadoc)
     * @see Object#toString()
     */
    public String toString() {
        return "id=" + id + ", type=" + type;
    }

    // =============================================================== Access methods

    public String getId() {
        return id;
    }

    public Integer getType() {
        return type;
    }

}
